/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.identifiable.entity.parts;

import de.digitalcollections.cudami.server.business.api.service.LocaleService;
import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.parts.SubtopicService;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Node;
import de.digitalcollections.model.api.identifiable.entity.Entity;
import de.digitalcollections.model.api.identifiable.entity.Topic;
import de.digitalcollections.model.api.identifiable.entity.parts.Subtopic;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.paging.Order;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.paging.Sorting;
import de.digitalcollections.model.api.view.BreadcrumbNavigation;
import de.digitalcollections.model.impl.paging.PageRequestImpl;
import de.digitalcollections.model.impl.paging.SortingImpl;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import org.jsondoc.core.annotation.Api;
import org.jsondoc.core.annotation.ApiMethod;
import org.jsondoc.core.annotation.ApiPathParam;
import org.jsondoc.core.annotation.ApiQueryParam;
import org.jsondoc.core.annotation.ApiResponseObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(description="The subtopic controller", name="Subtopic controller")
public class SubtopicController {
    @Autowired
    private LocaleService localeService;
    @Autowired
    private SubtopicService service;

    @ApiMethod(description="Add an existing subtopic to an existing parent subtopic")
    @PostMapping(value={"/latest/subtopics/{parentSubtopicUuid}/subtopic/{subtopicUuid}", "/v2/subtopics/{parentSubtopicUuid}/subtopic/{subtopicUuid}"}, produces={"application/json"})
    @ApiResponseObject
    public Subtopic addSubtopicToParentSubtopic(@ApiPathParam(name="parentSubtopicUuid", description="The uuid of the parent subtopic") @PathVariable UUID parentSubtopicUuid, @ApiPathParam(name="subtopicUuid", description="The uuid of the subtopic") @PathVariable UUID subtopicUuid) throws IdentifiableServiceException {
        return this.service.addSubtopicToParentSubtopic(subtopicUuid, parentSubtopicUuid);
    }

    @ApiMethod(description="Add an existing subtopic to an existing topic")
    @PostMapping(value={"/latest/topics/{parentTopicUuid}/subtopic/{subtopicUuid}", "/v2/topics/{parentTopicUuid}/subtopic/{subtopicUuid}"}, produces={"application/json"})
    @ApiResponseObject
    public Subtopic addSubtopicToParentTopic(@ApiPathParam(name="parentTopicUuid", description="The uuid of the parent topic") @PathVariable UUID parentTopicUuid, @ApiPathParam(name="subtopicUuid", description="The uuid of the subtopic") @PathVariable UUID subtopicUuid) throws IdentifiableServiceException {
        return this.service.addSubtopicToParentTopic(subtopicUuid, parentTopicUuid);
    }

    @ApiMethod(description="Get count of subtopics")
    @GetMapping(value={"/latest/subtopics/count", "/v2/subtopics/count"}, produces={"application/json"})
    @ApiResponseObject
    public long count() {
        return this.service.count();
    }

    @ApiMethod(description="Get all subtopics")
    @GetMapping(value={"/latest/subtopics", "/v2/subtopics"}, produces={"application/json"})
    @ApiResponseObject
    public PageResponse<Subtopic> findAll(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="sortBy", required=false) List<Order> sortBy) {
        PageRequestImpl pageRequest = new PageRequestImpl(pageNumber, pageSize);
        if (sortBy != null) {
            SortingImpl sorting = new SortingImpl(sortBy);
            pageRequest.setSorting((Sorting)sorting);
        }
        return this.service.find((PageRequest)pageRequest);
    }

    @ApiMethod(description="Get the breadcrumb for a subtopic")
    @GetMapping(value={"/latest/subtopics/{uuid}/breadcrumb", "/v3/subtopics/{uuid}/breadcrumb"}, produces={"application/json"})
    @ApiResponseObject
    public ResponseEntity<BreadcrumbNavigation> getBreadcrumb(@ApiPathParam(description="UUID of the subtopic, e.g. <tt>6119d8e9-9c92-4091-8dcb-bc4053385406</tt>") @PathVariable(value="uuid") UUID uuid, @ApiQueryParam(name="pLocale", description="Desired locale, e.g. <tt>de_DE</tt>. If unset, contents in all languages will be returned") @RequestParam(name="pLocale", required=false) Locale pLocale) {
        BreadcrumbNavigation breadcrumbNavigation = pLocale == null ? this.service.getBreadcrumbNavigation(uuid) : this.service.getBreadcrumbNavigation(uuid, pLocale, this.localeService.getDefaultLocale());
        if (breadcrumbNavigation == null || breadcrumbNavigation.getNavigationItems().isEmpty()) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)breadcrumbNavigation, HttpStatus.OK);
    }

    @ApiMethod(description="Get child subtopics of subtopic")
    @GetMapping(value={"/latest/subtopics/{uuid}/children", "/v2/subtopics/{uuid}/children"}, produces={"application/json"})
    @ApiResponseObject
    List<Subtopic> getChildren(@PathVariable UUID uuid) {
        return this.service.getChildren(uuid);
    }

    @ApiMethod(description="Get entities of subtopic")
    @GetMapping(value={"/latest/subtopics/{uuid}/entities", "/v2/subtopics/{uuid}/entities"}, produces={"application/json"})
    @ApiResponseObject
    public List<Entity> getEntities(@ApiPathParam(name="uuid", description="The uuid of the subtopic") @PathVariable UUID uuid) {
        return this.service.getEntities(uuid);
    }

    @ApiMethod(description="Get file resources of subtopic")
    @GetMapping(value={"/latest/subtopics/{uuid}/fileresources", "/v2/subtopics/{uuid}/fileresources"}, produces={"application/json"})
    @ApiResponseObject
    public List<FileResource> getFileResources(@PathVariable UUID uuid) {
        return this.service.getFileResources(uuid);
    }

    @ApiMethod(description="Get parent subtopic of subtopic")
    @GetMapping(value={"/latest/subtopics/{uuid}/parent", "/v2/subtopics/{uuid}/parent"}, produces={"application/json"})
    @ApiResponseObject
    Subtopic getParent(@PathVariable UUID uuid) {
        return (Subtopic)this.service.getParent(uuid);
    }

    @ApiMethod(description="Get a subtopic as JSON or XML, depending on extension or <tt>format</tt> request parameter or accept header")
    @GetMapping(value={"/latest/subtopics/{uuid}", "/v2/subtopics/{uuid}"}, produces={"application/json", "application/xml"})
    @ApiResponseObject
    public ResponseEntity<Subtopic> getSubtopic(@ApiPathParam(description="UUID of the subtopic, e.g. <tt>599a120c-2dd5-11e8-b467-0ed5f89f718b</tt>") @PathVariable(value="uuid") UUID uuid, @ApiQueryParam(name="pLocale", description="Desired locale, e.g. <tt>de_DE</tt>. If unset, contents in all languages will be returned") @RequestParam(name="pLocale", required=false) Locale pLocale) throws IdentifiableServiceException {
        Subtopic subtopic = pLocale == null ? (Subtopic)this.service.get(uuid) : (Subtopic)this.service.get(uuid, pLocale);
        return new ResponseEntity((Object)subtopic, HttpStatus.OK);
    }

    @ApiMethod(description="Get subtopics an entity is linked to")
    @GetMapping(value={"/latest/subtopics/entity/{uuid}", "/v2/subtopics/entity/{uuid}"}, produces={"application/json"})
    @ApiResponseObject
    List<Subtopic> getSubtopicsOfEntity(@PathVariable UUID uuid) {
        return this.service.getSubtopicsOfEntity(uuid);
    }

    @ApiMethod(description="Get subtopics a fileresource is linked to")
    @GetMapping(value={"/latest/subtopics/fileresource/{uuid}", "/v2/subtopics/fileresource/{uuid}"}, produces={"application/json"})
    @ApiResponseObject
    List<Subtopic> getSubtopicsOfFileResource(@PathVariable UUID uuid) {
        return this.service.getSubtopicsOfFileResource(uuid);
    }

    @ApiMethod(description="Get the topic of a subtopic")
    @GetMapping(value={"/latest/subtopics/{uuid}/topic", "/v3/subtopics/{uuid}/topic"}, produces={"application/json"})
    @ApiResponseObject
    public Topic getTopic(@ApiPathParam(description="UUID of the subtopic, e.g. <tt>6119d8e9-9c92-4091-8dcb-bc4053385406</tt>") @PathVariable(value="uuid") UUID uuid, @ApiQueryParam(name="pLocale", description="Desired locale, e.g. <tt>de_DE</tt>. If unset, contents in all languages will be returned") @RequestParam(name="pLocale", required=false) Locale pLocale) {
        return this.service.getTopic(uuid);
    }

    @ApiMethod(description="Remove child-relation of the given subtopic to the given parent subtopic")
    @DeleteMapping(value={"/latest/subtopics/{parentSubtopicUuid}/subtopic/{subtopicUuid}", "/v2/subtopics/{parentSubtopicUuid}/subtopic/{subtopicUuid}"}, produces={"application/json"})
    @ApiResponseObject
    Integer removeSubtopicFromParentSubtopic(@ApiPathParam(name="parentSubtopicUuid", description="The uuid of the parent subtopic") @PathVariable UUID parentSubtopicUuid, @ApiPathParam(name="subtopicUuid", description="The uuid of the subtopic") @PathVariable UUID subtopicUuid) {
        return this.service.removeFromParentSubtopic(subtopicUuid, parentSubtopicUuid);
    }

    @ApiMethod(description="Remove child-relation of the given subtopic to the given parent topic")
    @DeleteMapping(value={"/latest/topic/{topicUuid}/subtopic/{subtopicUuid}", "/v2/topic/{topicUuid}/subtopic/{subtopicUuid}"}, produces={"application/json"})
    @ApiResponseObject
    Integer removeSubtopicFromParentTopic(@ApiPathParam(name="topicUuid", description="The uuid of the parent topic") @PathVariable UUID topicUuid, @ApiPathParam(name="subtopicUuid", description="The uuid of the subtopic") @PathVariable UUID subtopicUuid) {
        return this.service.removeFromParentTopic(subtopicUuid, topicUuid);
    }

    @ApiMethod(description="Save entities of subtopic")
    @PostMapping(value={"/latest/subtopics/{uuid}/entities", "/v2/subtopics/{uuid}/entities"}, produces={"application/json"})
    @ApiResponseObject
    public List<Entity> saveEntities(@PathVariable UUID uuid, @RequestBody List<Entity> entities) {
        return this.service.saveEntities(uuid, entities);
    }

    @ApiMethod(description="Save fileresources of subtopic")
    @PostMapping(value={"/latest/subtopics/{uuid}/fileresources", "/v2/subtopics/{uuid}/fileresources"}, produces={"application/json"})
    @ApiResponseObject
    public List<FileResource> saveFileresources(@PathVariable UUID uuid, @RequestBody List<FileResource> fileResources) {
        return this.service.saveFileResources(uuid, fileResources);
    }

    @ApiMethod(description="Save a newly created subtopic")
    @PostMapping(value={"/latest/subtopics/{parentSubtopicUuid}/subtopic", "/v2/subtopics/{parentSubtopicUuid}/subtopic"}, produces={"application/json"})
    @ApiResponseObject
    public Subtopic saveWithParentSubtopic(@ApiPathParam(name="parentSubtopicUuid", description="The uuid of the parent subtopic") @PathVariable UUID parentSubtopicUuid, @RequestBody Subtopic subtopic) throws IdentifiableServiceException {
        return (Subtopic)this.service.saveWithParent((Node)subtopic, parentSubtopicUuid);
    }

    @ApiMethod(description="Save a newly created top-level subtopic")
    @PostMapping(value={"/latest/topics/{parentTopicUuid}/subtopic", "/v2/topics/{parentTopicUuid}/subtopic"}, produces={"application/json"})
    @ApiResponseObject
    public Subtopic saveWithParentTopic(@ApiPathParam(name="parentTopicUuid", description="The uuid of the parent topic") @PathVariable UUID parentTopicUuid, @RequestBody Subtopic subtopic, BindingResult errors) throws IdentifiableServiceException {
        return this.service.saveWithParentTopic(subtopic, parentTopicUuid);
    }

    @ApiMethod(description="Update a subtopic")
    @PutMapping(value={"/latest/subtopics/{uuid}", "/v2/subtopics/{uuid}"}, produces={"application/json"})
    @ApiResponseObject
    public Subtopic update(@ApiPathParam(name="uuid", description="The uuid of the subtopic") @PathVariable UUID uuid, @RequestBody Subtopic subtopic, BindingResult errors) throws IdentifiableServiceException {
        assert (Objects.equals(uuid, subtopic.getUuid()));
        return (Subtopic)this.service.update((Identifiable)subtopic);
    }
}

