/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.identifiable.resource;

import de.digitalcollections.cudami.server.business.api.service.LocaleService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.FileResourceBinaryService;
import de.digitalcollections.cudami.server.business.impl.service.identifiable.resource.FileResourceMetadataServiceImpl;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.identifiable.resource.MimeType;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.apache.tomcat.util.http.fileupload.FileItemIterator;
import org.apache.tomcat.util.http.fileupload.FileItemStream;
import org.apache.tomcat.util.http.fileupload.servlet.ServletFileUpload;
import org.jsondoc.core.annotation.Api;
import org.jsondoc.core.annotation.ApiResponseObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(description="The file upload controller", name="File upload controller")
public class FileResourceBinaryController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileResourceBinaryController.class);
    @Autowired
    FileResourceMetadataServiceImpl fileResourceService;
    @Autowired
    FileResourceBinaryService fileUploadService;
    @Autowired
    LocaleService localeService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/latest/files", "/v2/files"})
    @ApiResponseObject
    public FileResource upload(HttpServletRequest request) throws IOException {
        FileResource fileResource = null;
        try (InputStream stream = null;){
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
            if (!isMultipart) {
                throw new InvalidObjectException("no multipart content");
            }
            ServletFileUpload upload = new ServletFileUpload();
            FileItemIterator iter = upload.getItemIterator(request);
            while (iter.hasNext()) {
                FileItemStream item = iter.next();
                if (item.isFormField()) continue;
                stream = item.openStream();
                String originalFilename = item.getName();
                originalFilename = URLDecoder.decode(originalFilename, StandardCharsets.UTF_8.toString());
                String contentType = item.getContentType();
                fileResource = this.fileResourceService.createByMimeType(MimeType.fromTypename((String)contentType));
                fileResource.setFilename(originalFilename);
                LOGGER.info("filename = " + fileResource.getFilename());
                fileResource = this.fileUploadService.save(fileResource, stream);
                LOGGER.info("saved file '" + fileResource.getUri().toString() + "' (" + fileResource.getSizeInBytes() + " bytes)");
                stream.close();
            }
        }
        return fileResource;
    }
}

