/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.identifiable.entity;

import de.digitalcollections.cudami.server.business.api.service.LocaleService;
import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.TopicService;
import de.digitalcollections.model.filter.FilterCriterion;
import de.digitalcollections.model.filter.Filtering;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.Topic;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.paging.Order;
import de.digitalcollections.model.paging.PageRequest;
import de.digitalcollections.model.paging.PageResponse;
import de.digitalcollections.model.paging.SearchPageRequest;
import de.digitalcollections.model.paging.Sorting;
import de.digitalcollections.model.view.BreadcrumbNavigation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Topic controller")
public class TopicController {
    private final LocaleService localeService;
    private final TopicService topicService;

    public TopicController(LocaleService localeService, TopicService topicService) {
        this.localeService = localeService;
        this.topicService = topicService;
    }

    @Operation(summary="Add an existing topic to an existing parent topic")
    @PostMapping(value={"/v5/topics/{parentTopicUuid}/subtopic/{subtopicUuid}", "/v3/topics/{parentTopicUuid}/subtopic/{subtopicUuid}", "/latest/topics/{parentTopicUuid}/subtopic/{subtopicUuid}"}, produces={"application/json"})
    public ResponseEntity<Boolean> addChild(@Parameter(name="parentTopicUuid", description="The uuid of the parent topic") @PathVariable UUID parentTopicUuid, @Parameter(name="subtopicUuid", description="The uuid of the subtopic") @PathVariable UUID subtopicUuid) throws IdentifiableServiceException {
        boolean successful = this.topicService.addChild(parentTopicUuid, subtopicUuid);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }

    @Operation(summary="Get count of topics")
    @GetMapping(value={"/v5/topics/count", "/v2/topics/count", "/latest/topics/count"}, produces={"application/json"})
    public long count() {
        return this.topicService.count();
    }

    @Operation(summary="Get all topics")
    @GetMapping(value={"/v5/topics", "/v2/topics", "/latest/topics"}, produces={"application/json"})
    public PageResponse<Topic> findAll(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="sortBy", required=false) List<Order> sortBy, @RequestParam(name="searchTerm", required=false) String searchTerm) {
        SearchPageRequest pageRequest = new SearchPageRequest(searchTerm, pageNumber, pageSize);
        if (sortBy != null) {
            Sorting sorting = new Sorting(sortBy);
            pageRequest.setSorting(sorting);
        }
        return this.topicService.find(pageRequest);
    }

    @Operation(summary="Get all top topics")
    @GetMapping(value={"/v5/topics/top", "/v3/topics/top", "/latest/topics/top"}, produces={"application/json"})
    public PageResponse<Topic> findAllTop(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="5") int pageSize, @RequestParam(name="sortBy", required=false) List<Order> sortBy, @RequestParam(name="searchTerm", required=false) String searchTerm) {
        SearchPageRequest searchPageRequest = new SearchPageRequest(searchTerm, pageNumber, pageSize);
        if (sortBy != null) {
            Sorting sorting = new Sorting(sortBy);
            searchPageRequest.setSorting(sorting);
        }
        return this.topicService.findRootNodes(searchPageRequest);
    }

    @Operation(summary="Get topic by uuid (and optional locale)")
    @GetMapping(value={"/v5/topics/{uuid:[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}}", "/v2/topics/{uuid:[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}}", "/latest/topics/{uuid:[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}}"}, produces={"application/json"})
    public ResponseEntity<Topic> findById(@Parameter(example="", description="UUID of the topic, e.g. <tt>599a120c-2dd5-11e8-b467-0ed5f89f718b</tt>") @PathVariable(value="uuid") UUID uuid, @Parameter(name="pLocale", description="Desired locale, e.g. <tt>de_DE</tt>. If unset, contents in all languages will be returned") @RequestParam(name="pLocale", required=false) Locale pLocale) throws IdentifiableServiceException {
        Topic topic = pLocale == null ? (Topic)this.topicService.get(uuid) : (Topic)this.topicService.get(uuid, pLocale);
        return new ResponseEntity((Object)topic, HttpStatus.OK);
    }

    @Operation(summary="Get topic by refId")
    @GetMapping(value={"/v5/topics/{refId:[0-9]+}", "/v3/topics/{refId:[0-9]+}", "/latest/topics/{refId:[0-9]+}"}, produces={"application/json"})
    public ResponseEntity<Topic> findByRefId(@Parameter(name="refId", example="", description="refId of the topic, e.g. <tt>42</tt>") @PathVariable long refId) throws IdentifiableServiceException {
        Topic topic = (Topic)this.topicService.getByRefId(refId);
        return this.findById(topic.getUuid(), null);
    }

    @Operation(summary="Get (active or all) paged subtopics of a topic")
    @GetMapping(value={"/v5/topics/{uuid}/subtopics"}, produces={"application/json"})
    public PageResponse<Topic> getSubtopics(@Parameter(example="", description="UUID of the topic") @PathVariable(value="uuid") UUID topicUuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="sortBy", required=false) List<Order> sortBy, @RequestParam(name="searchTerm", required=false) String searchTerm) {
        SearchPageRequest searchPageRequest = new SearchPageRequest(searchTerm, pageNumber, pageSize);
        if (sortBy != null) {
            Sorting sorting = new Sorting(sortBy);
            searchPageRequest.setSorting(sorting);
        }
        return this.topicService.findChildren(topicUuid, searchPageRequest);
    }

    @Operation(summary="Get the breadcrumb for a topic")
    @GetMapping(value={"/v5/topics/{uuid}/breadcrumb", "/v3/topics/{uuid}/breadcrumb", "/latest/topics/{uuid}/breadcrumb"}, produces={"application/json"})
    public ResponseEntity<BreadcrumbNavigation> getBreadcrumb(@Parameter(example="", description="UUID of the topic, e.g. <tt>6119d8e9-9c92-4091-8dcb-bc4053385406</tt>") @PathVariable(value="uuid") UUID uuid, @Parameter(name="pLocale", description="Desired locale, e.g. <tt>de_DE</tt>. If unset, contents in all languages will be returned") @RequestParam(name="pLocale", required=false) Locale pLocale) {
        BreadcrumbNavigation breadcrumbNavigation = pLocale == null ? this.topicService.getBreadcrumbNavigation(uuid) : this.topicService.getBreadcrumbNavigation(uuid, pLocale, this.localeService.getDefaultLocale());
        if (breadcrumbNavigation == null || breadcrumbNavigation.getNavigationItems().isEmpty()) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)breadcrumbNavigation, HttpStatus.OK);
    }

    @Operation(summary="Get subtopics of topic")
    @GetMapping(value={"/v5/topics/{uuid}/children", "/v3/topics/{uuid}/children", "/latest/topics/{uuid}/children"}, produces={"application/json"})
    List<Topic> getChildren(@PathVariable UUID uuid) {
        return this.topicService.getChildren(uuid);
    }

    @Operation(summary="Get all entities of topic")
    @GetMapping(value={"/v5/topics/{uuid}/entities/all", "/v3/topics/{uuid}/entities/all", "/latest/topics/{uuid}/entities/all"}, produces={"application/json"})
    public List<Entity> getEntities(@Parameter(name="uuid", description="The uuid of the topic") @PathVariable UUID uuid) {
        return this.topicService.getAllEntities(uuid);
    }

    @Operation(summary="Get paged entities of a topic")
    @GetMapping(value={"/v5/topics/{uuid}/entities", "/v3/topics/{uuid}/entities", "/latest/topics/{uuid}/entities"}, produces={"application/json"})
    public PageResponse<Entity> getEntities(@Parameter(example="", description="UUID of the topic") @PathVariable(value="uuid") UUID topicUuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="entityType", required=false) FilterCriterion<String> entityType) {
        PageRequest pageRequest = new PageRequest(pageNumber, pageSize, new Sorting());
        if (entityType != null) {
            Filtering filtering = Filtering.defaultBuilder().add("entityType", entityType).build();
            pageRequest.setFiltering(filtering);
        }
        return this.topicService.getEntities(topicUuid, pageRequest);
    }

    @Operation(summary="Get file resources of topic")
    @GetMapping(value={"/v5/topics/{uuid}/fileresources", "/v3/topics/{uuid}/fileresources", "/latest/topics/{uuid}/fileresources"}, produces={"application/json"})
    public PageResponse<FileResource> getFileResources(@PathVariable UUID uuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize) {
        return this.topicService.getFileResources(uuid, new PageRequest(pageNumber, pageSize));
    }

    @Operation(summary="Get all languages of entities of a topic")
    @GetMapping(value={"/v5/topics/{uuid}/entities/languages"}, produces={"application/json"})
    public List<Locale> getLanguagesOfEntities(@PathVariable UUID uuid) {
        return this.topicService.getLanguagesOfEntities(uuid);
    }

    @Operation(summary="Get all languages of file resources of a topic")
    @GetMapping(value={"/v5/topics/{uuid}/fileresources/languages"}, produces={"application/json"})
    public List<Locale> getLanguagesOfFileResources(@PathVariable UUID uuid) {
        return this.topicService.getLanguagesOfFileResources(uuid);
    }

    @Operation(summary="Get parent topic of topic")
    @GetMapping(value={"/v5/topics/{uuid}/parent", "/v3/topics/{uuid}/parent", "/latest/topics/{uuid}/parent"}, produces={"application/json"})
    Topic getParent(@PathVariable UUID uuid) {
        return (Topic)this.topicService.getParent(uuid);
    }

    @Operation(summary="Get subtopics of topic")
    @GetMapping(value={"/v2/topics/{uuid}/subtopics"}, produces={"application/json"})
    ResponseEntity<String> getSubtopics(@PathVariable UUID uuid) {
        return new ResponseEntity((Object)"no longer supported. use '/v3/topics/{uuid}/children' endpoint, returning list of child-topics", HttpStatus.GONE);
    }

    @Operation(summary="Get topics an entity is linked to")
    @GetMapping(value={"/v5/topics/entity/{uuid}", "/v3/topics/entity/{uuid}", "/latest/topics/entity/{uuid}"}, produces={"application/json"})
    List<Topic> getTopicsOfEntity(@PathVariable UUID uuid) {
        return this.topicService.getTopicsOfEntity(uuid);
    }

    @Operation(summary="Get topics a fileresource is linked to")
    @GetMapping(value={"/v5/topics/fileresource/{uuid}", "/v3/topics/fileresource/{uuid}", "/latest/topics/fileresource/{uuid}"}, produces={"application/json"})
    List<Topic> getTopicsOfFileResource(@PathVariable UUID uuid) {
        return this.topicService.getTopicsOfFileResource(uuid);
    }

    @Operation(summary="Get languages of all top topics")
    @GetMapping(value={"/v5/topics/top/languages", "/v3/topics/top/languages", "/latest/topics/top/languages"}, produces={"application/json"})
    public List<Locale> getTopTopicsLanguages() {
        return this.topicService.getRootNodesLanguages();
    }

    @Operation(summary="Remove child-relation of the given subtopic to the given parent topic")
    @DeleteMapping(value={"/v5/topics/{parentTopicUuid}/children/{subtopicUuid}", "/v3/topics/{parentTopicUuid}/children/{subtopicUuid}", "/latest/topics/{parentTopicUuid}/children/{subtopicUuid}"}, produces={"application/json"})
    ResponseEntity<Boolean> removeChild(@Parameter(name="parentTopicUuid", description="The uuid of the parent topic") @PathVariable UUID parentTopicUuid, @Parameter(name="subtopicUuid", description="The uuid of the subtopic") @PathVariable UUID subtopicUuid) {
        boolean successful = this.topicService.removeChild(parentTopicUuid, subtopicUuid);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }

    @Operation(summary="Save a newly created topic")
    @PostMapping(value={"/v5/topics", "/v2/topics", "/latest/topics"}, produces={"application/json"})
    public Topic save(@RequestBody Topic topic, BindingResult errors) throws IdentifiableServiceException {
        return (Topic)this.topicService.save((Identifiable)topic);
    }

    @Operation(summary="Save entities of topic")
    @PostMapping(value={"/v5/topics/{uuid}/entities", "/v3/topics/{uuid}/entities", "/latest/topics/{uuid}/entities"}, produces={"application/json"})
    public List<Entity> saveEntities(@PathVariable UUID uuid, @RequestBody List<Entity> entities) {
        return this.topicService.saveEntities(uuid, entities);
    }

    @Operation(summary="Save fileresources of topic")
    @PostMapping(value={"/v5/topics/{uuid}/fileresources", "/v3/topics/{uuid}/fileresources", "/latest/topics/{uuid}/fileresources"}, produces={"application/json"})
    public List<FileResource> saveFileresources(@PathVariable UUID uuid, @RequestBody List<FileResource> fileResources) {
        return this.topicService.saveFileResources(uuid, fileResources);
    }

    @Operation(summary="Save a newly created topic and add it to parent")
    @PostMapping(value={"/v5/topics/{parentTopicUuid}/subtopic", "/v3/topics/{parentTopicUuid}/subtopic", "/latest/topics/{parentTopicUuid}/subtopic"}, produces={"application/json"})
    public Topic saveWithParentTopic(@Parameter(name="parentTopicUuid", description="The uuid of the parent topic") @PathVariable UUID parentTopicUuid, @RequestBody Topic topic, BindingResult errors) throws IdentifiableServiceException {
        return (Topic)this.topicService.saveWithParent((Identifiable)topic, parentTopicUuid);
    }

    @Operation(summary="Update a topic")
    @PutMapping(value={"/v5/topics/{uuid}", "/v2/topics/{uuid}", "/latest/topics/{uuid}"}, produces={"application/json"})
    public Topic update(@PathVariable UUID uuid, @RequestBody Topic topic, BindingResult errors) throws IdentifiableServiceException {
        assert (Objects.equals(uuid, topic.getUuid()));
        return (Topic)this.topicService.update((Identifiable)topic);
    }
}

