/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.identifiable.agent;

import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.agent.FamilyNameService;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.agent.FamilyName;
import de.digitalcollections.model.paging.Order;
import de.digitalcollections.model.paging.PageRequest;
import de.digitalcollections.model.paging.PageResponse;
import de.digitalcollections.model.paging.Sorting;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Family name controller")
public class FamilyNameController {
    private final FamilyNameService familyNameService;

    public FamilyNameController(FamilyNameService familyNameservice) {
        this.familyNameService = familyNameservice;
    }

    @Operation(summary="get all family names")
    @GetMapping(value={"/v5/familynames"}, produces={"application/json"})
    public PageResponse<FamilyName> findAll(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="5") int pageSize, @RequestParam(name="sortBy", required=false) List<Order> sortBy, @RequestParam(name="language", required=false, defaultValue="de") String language, @RequestParam(name="initial", required=false) String initial) {
        PageRequest pageRequest = new PageRequest(pageNumber, pageSize);
        if (sortBy != null) {
            Sorting sorting = new Sorting(sortBy);
            pageRequest.setSorting(sorting);
        }
        if (initial == null) {
            return this.familyNameService.find(pageRequest);
        }
        return this.familyNameService.findByLanguageAndInitial(pageRequest, language, initial);
    }

    @Operation(summary="Get a familyname by uuid")
    @GetMapping(value={"/v5/familynames/{uuid}"}, produces={"application/json"})
    public ResponseEntity<FamilyName> get(@Parameter(example="", description="UUID of the familyname, e.g. <tt>599a120c-2dd5-11e8-b467-0ed5f89f718b</tt>") @PathVariable(value="uuid") UUID uuid, @Parameter(example="", name="pLocale", description="Desired locale, e.g. <tt>de_DE</tt>. If unset, contents in all languages will be returned") @RequestParam(name="pLocale", required=false) Locale pLocale) throws IdentifiableServiceException {
        FamilyName result = pLocale == null ? (FamilyName)this.familyNameService.get(uuid) : (FamilyName)this.familyNameService.get(uuid, pLocale);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Operation(summary="Get a familyname by namespace and id")
    @GetMapping(value={"/v5/familynames/identifier"}, produces={"application/json"})
    public ResponseEntity<FamilyName> getByIdentifier(@RequestParam(name="namespace", required=true) String namespace, @RequestParam(name="id", required=true) String id) throws IdentifiableServiceException {
        FamilyName result = (FamilyName)this.familyNameService.getByIdentifier(namespace, id);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Operation(summary="save a newly created family")
    @PostMapping(value={"/v5/familynames"}, produces={"application/json"})
    public FamilyName save(@RequestBody FamilyName familyName, BindingResult errors) throws IdentifiableServiceException {
        return (FamilyName)this.familyNameService.save((Identifiable)familyName);
    }

    @Operation(summary="update a familyname")
    @PutMapping(value={"/v5/familynames/{uuid}"}, produces={"application/json"})
    public FamilyName update(@PathVariable(value="uuid") UUID uuid, @RequestBody FamilyName familyName, BindingResult errors) throws IdentifiableServiceException {
        assert (Objects.equals(uuid, familyName.getUuid()));
        return (FamilyName)this.familyNameService.update((Identifiable)familyName);
    }
}

