/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.converter;

import de.digitalcollections.model.filter.FilterCriterion;
import de.digitalcollections.model.filter.FilterOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class StringToFilterCriteriaGenericConverter<C extends Comparable<C>>
implements GenericConverter {
    @Autowired
    private ConversionService conversionService;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        HashSet<GenericConverter.ConvertiblePair> convertibleTypes = new HashSet<GenericConverter.ConvertiblePair>();
        convertibleTypes.add(new GenericConverter.ConvertiblePair(String.class, FilterCriterion.class));
        return convertibleTypes;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        Class targetClass = (Class)targetType.getResolvableType().getGeneric(new int[]{0}).getType();
        return this.convert(source, targetClass);
    }

    protected Object convert(Object source, Class targetClass) throws IllegalArgumentException {
        if (source == null) {
            return null;
        }
        String operationAndValues = (String)source;
        if (!operationAndValues.contains(":")) {
            throw new IllegalArgumentException("No separator ':' found");
        }
        int separatorPosition = operationAndValues.indexOf(58);
        String operationAcronym = operationAndValues.substring(0, separatorPosition);
        if (operationAcronym == null) {
            throw new IllegalArgumentException("No operation acronym found");
        }
        String operationValue = operationAndValues.substring(separatorPosition + 1);
        FilterOperation filterOperation = FilterOperation.fromValue((String)operationAcronym);
        if (filterOperation.getOperandCount() == FilterOperation.OperandCount.NO_VALUE) {
            FilterCriterion fc = new FilterCriterion(null, filterOperation, null, null, null, null);
            return fc;
        }
        if (filterOperation.getOperandCount() == FilterOperation.OperandCount.SINGLEVALUE) {
            if (operationValue == null) {
                throw new IllegalArgumentException("No operation value found");
            }
            Object value = this.conversionService.convert((Object)operationValue, targetClass);
            FilterCriterion fc = new FilterCriterion(null, filterOperation, value);
            return fc;
        }
        if (filterOperation.getOperandCount() == FilterOperation.OperandCount.MULTIVALUE) {
            if (operationValue == null) {
                throw new IllegalArgumentException("No operation values found");
            }
            String[] operationValues = StringUtils.tokenizeToStringArray((String)operationValue, (String)",");
            if (operationValues == null || operationValues.length < 1) {
                throw new IllegalArgumentException("Operation values can't be empty");
            }
            List<String> originalValues = Arrays.asList(operationValues);
            ArrayList convertedValues = new ArrayList();
            convertedValues.addAll(originalValues.stream().map(s -> this.conversionService.convert(s, targetClass)).collect(Collectors.toList()));
            FilterCriterion fc = new FilterCriterion(null, filterOperation, null, null, null, convertedValues);
            return fc;
        }
        if (filterOperation.getOperandCount() == FilterOperation.OperandCount.MIN_MAX_VALUES) {
            if (operationValue == null) {
                throw new IllegalArgumentException("No operation values found");
            }
            String[] operationValues = StringUtils.tokenizeToStringArray((String)operationValue, (String)",");
            if (operationValues == null || operationValues.length < 1) {
                throw new IllegalArgumentException("Operation values can't be empty");
            }
            if (operationValues.length != 2) {
                throw new IllegalArgumentException("For min/max operation two values are expected");
            }
            Comparable minValue = null;
            Comparable maxValue = null;
            Comparable value1 = (Comparable)this.conversionService.convert((Object)operationValues[0], targetClass);
            Comparable value2 = (Comparable)this.conversionService.convert((Object)operationValues[1], targetClass);
            if (value1 != null && value2 != null) {
                if (value1.compareTo(value2) > 0) {
                    minValue = value2;
                    maxValue = value1;
                } else {
                    minValue = value1;
                    maxValue = value2;
                }
            }
            FilterCriterion fc = new FilterCriterion(null, filterOperation, null, minValue, maxValue, null);
            return fc;
        }
        throw new IllegalArgumentException("Unknown operation '" + operationAcronym + "'");
    }
}

