/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.identifiable.entity;

import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.ProjectService;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.entity.DigitalObject;
import de.digitalcollections.model.identifiable.entity.Project;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Order;
import de.digitalcollections.model.list.sorting.Sorting;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Project controller")
public class ProjectController {
    private final ProjectService projectService;

    public ProjectController(ProjectService projectService) {
        this.projectService = projectService;
    }

    @Operation(summary="Add an existing digital object to an existing project")
    @PostMapping(value={"/v6/projects/{uuid}/digitalobjects/{digitalObjectUuid}", "/v5/projects/{uuid}/digitalobjects/{digitalObjectUuid}", "/v3/projects/{uuid}/digitalobjects/{digitalObjectUuid}", "/latest/projects/{uuid}/digitalobjects/{digitalObjectUuid}"}, produces={"application/json"})
    public ResponseEntity addDigitalObject(@Parameter(example="", description="UUID of the project") @PathVariable(value="uuid") UUID projectUuid, @Parameter(example="", description="UUID of the digital object") @PathVariable(value="digitalObjectUuid") UUID digitalObjectUuid) {
        Project project = new Project();
        project.setUuid(projectUuid);
        DigitalObject digitalObject = new DigitalObject();
        digitalObject.setUuid(digitalObjectUuid);
        boolean successful = this.projectService.addDigitalObject(project, digitalObject);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }

    @Operation(summary="Add existing digital objects to an existing project")
    @PostMapping(value={"/v6/projects/{uuid}/digitalobjects", "/v5/projects/{uuid}/digitalobjects", "/v3/projects/{uuid}/digitalobjects", "/latest/projects/{uuid}/digitalobjects"}, produces={"application/json"})
    public ResponseEntity addDigitalObjects(@Parameter(example="", description="UUID of the project") @PathVariable(value="uuid") UUID projectUuid, @Parameter(example="", description="List of the digital objects") @RequestBody List<DigitalObject> digitalObjects) {
        Project project = new Project();
        project.setUuid(projectUuid);
        boolean successful = this.projectService.addDigitalObjects(project, digitalObjects);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }

    @Operation(summary="Delete an existing project and the identifiers, which belong to this project")
    @DeleteMapping(value={"/v6/projects/{uuid}", "/v5/projects/{uuid}", "/v3/projects/{uuid}", "/latest/projects/{uuid}"}, produces={"application/json"})
    public ResponseEntity delete(@Parameter(example="", description="UUID of the project") @PathVariable(value="uuid") UUID uuid) {
        try {
            this.projectService.delete(uuid);
        }
        catch (IdentifiableServiceException e) {
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @Operation(summary="Get all projects as (sorted, paged) list")
    @GetMapping(value={"/v6/projects"}, produces={"application/json"})
    public PageResponse<Project> find(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="sortBy", required=false) List<Order> sortBy, @RequestParam(name="searchTerm", required=false) String searchTerm) {
        PageRequest searchPageRequest = new PageRequest(searchTerm, pageNumber, pageSize);
        if (sortBy != null) {
            Sorting sorting = new Sorting(sortBy);
            searchPageRequest.setSorting(sorting);
        }
        return this.projectService.find(searchPageRequest);
    }

    @Operation(summary="Get paged digital objects of a project")
    @GetMapping(value={"/v6/projects/{uuid}/digitalobjects"}, produces={"application/json"})
    public PageResponse<DigitalObject> findDigitalObjects(@Parameter(example="", description="UUID of the project") @PathVariable(value="uuid") UUID projectUuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="searchTerm", required=false) String searchTerm) {
        PageRequest searchPageRequest = new PageRequest(searchTerm, pageNumber, pageSize);
        Project project = new Project();
        project.setUuid(projectUuid);
        return this.projectService.findDigitalObjects(project, searchPageRequest);
    }

    @Operation(summary="Get project by namespace and id")
    @GetMapping(value={"/v6/projects/identifier/{namespace}:{id}", "/v6/projects/identifier/{namespace}:{id}.json", "/v5/projects/identifier/{namespace}:{id}", "/v5/projects/identifier/{namespace}:{id}.json", "/v3/projects/identifier/{namespace}:{id}", "/v3/projects/identifier/{namespace}:{id}.json", "/latest/projects/identifier/{namespace}:{id}", "/latest/projects/identifier/{namespace}:{id}.json"}, produces={"application/json"})
    public Project getByIdentifier(@PathVariable String namespace, @PathVariable String id) throws IdentifiableServiceException {
        return (Project)this.projectService.getByIdentifier(namespace, id);
    }

    @Operation(summary="Get a project by uuid")
    @GetMapping(value={"/v6/projects/{uuid}", "/v5/projects/{uuid}", "/v2/projects/{uuid}", "/latest/projects/{uuid}"}, produces={"application/json"})
    public ResponseEntity<Project> getByUuid(@Parameter(example="", description="UUID of the project, e.g. <tt>599a120c-2dd5-11e8-b467-0ed5f89f718b</tt>") @PathVariable(value="uuid") UUID uuid, @Parameter(name="pLocale", description="Desired locale, e.g. <tt>de_DE</tt>. If unset, contents in all languages will be returned") @RequestParam(name="pLocale", required=false) Locale pLocale) throws IdentifiableServiceException {
        Project project = pLocale == null ? (Project)this.projectService.getByUuid(uuid) : (Project)this.projectService.getByUuidAndLocale(uuid, pLocale);
        return new ResponseEntity((Object)project, HttpStatus.OK);
    }

    @Operation(summary="Get languages of all projects")
    @GetMapping(value={"/v6/projects/languages", "/v5/projects/languages", "/v3/projects/languages", "/latest/projects/languages"}, produces={"application/json"})
    public List<Locale> getLanguages() {
        return this.projectService.getLanguages();
    }

    @Operation(summary="Remove an existing digital object from an existing project")
    @DeleteMapping(value={"/v6/projects/{uuid}/digitalobjects/{digitalObjectUuid}", "/v5/projects/{uuid}/digitalobjects/{digitalObjectUuid}", "/v3/projects/{uuid}/digitalobjects/{digitalObjectUuid}", "/latest/projects/{uuid}/digitalobjects/{digitalObjectUuid}"}, produces={"application/json"})
    public ResponseEntity removeDigitalObject(@Parameter(example="", description="UUID of the project") @PathVariable(value="uuid") UUID projectUuid, @Parameter(example="", description="UUID of the digital object") @PathVariable(value="digitalObjectUuid") UUID digitalObjectUuid) {
        Project project = new Project();
        project.setUuid(projectUuid);
        DigitalObject digitalObject = new DigitalObject();
        digitalObject.setUuid(digitalObjectUuid);
        boolean successful = this.projectService.removeDigitalObject(project, digitalObject);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }

    @Operation(summary="Save a newly created project")
    @PostMapping(value={"/v6/projects", "/v5/projects", "/v2/projects", "/latest/projects"}, produces={"application/json"})
    public Project save(@RequestBody Project project, BindingResult errors) throws IdentifiableServiceException, ValidationException {
        return (Project)this.projectService.save((Identifiable)project);
    }

    @Operation(summary="Save existing digital objects into an existing project")
    @PutMapping(value={"/v6/projects/{uuid}/digitalobjects", "/v5/projects/{uuid}/digitalobjects", "/v3/projects/{uuid}/digitalobjects", "/latest/projects/{uuid}/digitalobjects"}, produces={"application/json"})
    public ResponseEntity setDigitalObjects(@Parameter(example="", description="UUID of the project") @PathVariable(value="uuid") UUID projectUuid, @Parameter(example="", description="List of the digital objects") @RequestBody List<DigitalObject> digitalObjects) {
        Project project = new Project();
        project.setUuid(projectUuid);
        boolean successful = this.projectService.setDigitalObjects(project, digitalObjects);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }

    @Operation(summary="Update an project")
    @PutMapping(value={"/v6/projects/{uuid}", "/v5/projects/{uuid}", "/v2/projects/{uuid}", "/latest/projects/{uuid}"}, produces={"application/json"})
    public Project update(@PathVariable UUID uuid, @RequestBody Project project, BindingResult errors) throws IdentifiableServiceException, ValidationException {
        assert (Objects.equals(uuid, project.getUuid()));
        return (Project)this.projectService.update((Identifiable)project);
    }
}

