/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.identifiable.entity;

import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.IdentifiableService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.EntityService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.relation.EntityRelationService;
import de.digitalcollections.cudami.server.controller.ParameterHelper;
import de.digitalcollections.cudami.server.controller.identifiable.AbstractIdentifiableController;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.relation.EntityRelation;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Order;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Entity controller")
public class EntityController<E extends Entity>
extends AbstractIdentifiableController<Entity> {
    private final EntityRelationService entityRelationService;
    private final EntityService<Entity> entityService;

    public EntityController(EntityRelationService entityRelationService, @Qualifier(value="entityService") EntityService<Entity> entityService) {
        this.entityRelationService = entityRelationService;
        this.entityService = entityService;
    }

    protected IdentifiableService<Entity> getService() {
        return this.entityService;
    }

    @Operation(summary="Get count of entities")
    @GetMapping(value={"/v6/entities/count", "/v5/entities/count", "/v3/entities/count", "/latest/entities/count"}, produces={"application/json"})
    public long count() {
        return this.entityService.count();
    }

    @Operation(summary="Get all entities")
    @GetMapping(value={"/v6/entities"}, produces={"application/json"})
    public PageResponse<Entity> find(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="sortBy", required=false) List<Order> sortBy, @RequestParam(name="searchTerm", required=false) String searchTerm, @RequestParam(name="label", required=false) String labelTerm, @RequestParam(name="labelLanguage", required=false) Locale labelLanguage, @RequestParam(name="entityType", required=false) FilterCriterion<String> entityTypeCriterion) {
        return super.find(pageNumber, pageSize, sortBy, searchTerm, labelTerm, labelLanguage, new Object[]{"entityType", entityTypeCriterion});
    }

    @Operation(summary="Get an entity by namespace and id", description="Separate namespace and id with a colon, e.g. foo:bar. It is also possible, to add a .json suffix, which will be ignored then")
    @GetMapping(value={"/v6/entities/identifier/**", "/v5/entities/identifier/**", "/latest/entities/identifier/**"}, produces={"application/json"})
    public ResponseEntity<Entity> getByIdentifier(HttpServletRequest request) throws IdentifiableServiceException, ValidationException {
        Entity entity;
        Pair namespaceAndId = ParameterHelper.extractPairOfStringsFromUri((String)request.getRequestURI(), (String)"^.*?/identifier/");
        if (((String)namespaceAndId.getLeft()).isBlank() || namespaceAndId.getRight() == null || ((String)namespaceAndId.getRight()).isBlank()) {
            throw new ValidationException("No namespace and/or id were provided in a colon separated manner");
        }
        return new ResponseEntity((Object)entity, (entity = (Entity)this.entityService.getByIdentifier((String)namespaceAndId.getLeft(), (String)namespaceAndId.getRight())) != null ? HttpStatus.OK : HttpStatus.NOT_FOUND);
    }

    @Operation(summary="Get entity by reference id")
    @GetMapping(value={"/v6/entities/{refId:[0-9]+}", "/v5/entities/{refId:[0-9]+}", "/latest/entities/{refId:[0-9]+}"}, produces={"application/json"})
    public Entity getByRefId(@PathVariable long refId) {
        Entity entity = this.entityService.getByRefId(refId);
        if (entity == null) {
            return null;
        }
        return entity;
    }

    @Operation(summary="Get entity by uuid")
    @GetMapping(value={"/v6/entities/{uuid:[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}}", "/v5/entities/{uuid:[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}}", "/v2/entities/{uuid:[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}}", "/latest/entities/{uuid:[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}}"}, produces={"application/json"})
    public Entity getByUuid(@PathVariable UUID uuid) {
        return (Entity)this.entityService.getByUuid(uuid);
    }

    @Operation(summary="Find limited amount of random entites")
    @GetMapping(value={"/v6/entities/random", "/v5/entities/random", "/v2/entities/random", "/latest/entities/random"}, produces={"application/json"})
    public List<Entity> getRandomEntities(@RequestParam(name="count", required=false, defaultValue="5") int count) {
        return this.entityService.getRandom(count);
    }

    @Operation(summary="Get related file resources of entity")
    @GetMapping(value={"/v6/entities/{uuid}/related/fileresources", "/v5/entities/{uuid}/related/fileresources", "/v2/entities/{uuid}/related/fileresources", "/latest/entities/{uuid}/related/fileresources"}, produces={"application/json"})
    List<FileResource> getRelatedFileResources(@PathVariable UUID uuid) {
        return this.entityService.getRelatedFileResources(uuid);
    }

    @Operation(summary="Get relations for an entity (being the subject)")
    @GetMapping(value={"/v6/entities/relations/{uuid}", "/v5/entities/relations/{uuid}", "/v2/entities/relations/{uuid}", "/latest/entities/relations/{uuid}"}, produces={"application/json"})
    List<EntityRelation> getRelations(@PathVariable UUID uuid) {
        return this.entityRelationService.getBySubject(uuid);
    }
}

