/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.advice;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import de.digitalcollections.cudami.server.controller.advice.EnsureObjectTypeAdvice;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdviceAdapter;

/*
 * Exception performing whole class analysis ignored.
 */
@RestControllerAdvice
public class EnsureObjectTypeAdvice
extends RequestBodyAdviceAdapter {
    private static final String ATTR_OBJECTTYPE = "objectType";
    private static final int LATEST_VERSION_WHICH_REQUIRES_FIX = 6;
    private static final Pattern VERSION_PATTERN = Pattern.compile(".*?/(v\\d+)/.*?");
    private final HttpServletRequest httpServletRequest;

    public EnsureObjectTypeAdvice(HttpServletRequest httpServletRequest) {
        this.httpServletRequest = httpServletRequest;
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        String method;
        switch (method = this.httpServletRequest.getMethod().toUpperCase(Locale.ROOT)) {
            case "POST": 
            case "PUT": 
            case "PATCH": {
                return this.checkVersion(this.httpServletRequest);
            }
        }
        return false;
    }

    private boolean checkVersion(HttpServletRequest httpServletRequest) {
        int version;
        Matcher matcher = VERSION_PATTERN.matcher(httpServletRequest.getRequestURL());
        return !matcher.matches() || (version = Integer.parseInt(matcher.group(1).substring(1))) <= 6;
    }

    public HttpInputMessage beforeBodyRead(HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) throws IOException {
        String body = new String(inputMessage.getBody().readAllBytes(), StandardCharsets.UTF_8);
        HttpInputMessage fixedInputMessage = inputMessage;
        if (body.length() >= 2) {
            if (body.startsWith("[")) {
                JSONArray jsonArray = new JSONArray(body);
                jsonArray = EnsureObjectTypeAdvice.fixJsonArray((JSONArray)jsonArray);
                fixedInputMessage = new FixedHttpInputMessage(inputMessage.getHeaders(), jsonArray.toString());
            } else {
                JSONObject jsonObject = new JSONObject(body);
                jsonObject = EnsureObjectTypeAdvice.fixJsonObject((JSONObject)jsonObject);
                fixedInputMessage = new FixedHttpInputMessage(inputMessage.getHeaders(), jsonObject.toString());
            }
        }
        return super.beforeBodyRead(fixedInputMessage, parameter, targetType, converterType);
    }

    private static JSONObject fixJsonObject(JSONObject jsonObject) {
        if (!jsonObject.has("objectType")) {
            EnsureObjectTypeAdvice.guessAndSetObjectType((JSONObject)jsonObject);
        }
        Iterator keyIt = jsonObject.keys();
        while (keyIt.hasNext()) {
            String key = (String)keyIt.next();
            Object jsonObj = jsonObject.get(key);
            if (jsonObj instanceof JSONObject) {
                jsonObject.put(key, (Object)EnsureObjectTypeAdvice.fixJsonObject((JSONObject)((JSONObject)jsonObj)));
            }
            if (!(jsonObj instanceof JSONArray)) continue;
            jsonObject.put(key, (Object)EnsureObjectTypeAdvice.fixJsonArray((JSONArray)((JSONArray)jsonObj)));
        }
        return jsonObject;
    }

    private static JSONArray fixJsonArray(JSONArray jsonArr) {
        for (int i = 0; i < jsonArr.length(); ++i) {
            Object obj = jsonArr.get(i);
            if (obj instanceof JSONObject) {
                jsonArr.put(i, (Object)EnsureObjectTypeAdvice.fixJsonObject((JSONObject)((JSONObject)obj)));
            }
            if (!(obj instanceof JSONArray)) continue;
            jsonArr.put(i, (Object)EnsureObjectTypeAdvice.fixJsonArray((JSONArray)((JSONArray)obj)));
        }
        return jsonArr;
    }

    private static void guessAndSetObjectType(JSONObject jsonObject) {
        if (jsonObject.has("namespace") && jsonObject.has("id")) {
            jsonObject.put("objectType", (Object)"IDENTIFIER");
            return;
        }
        if (jsonObject.has("acronym") && jsonObject.has("url")) {
            jsonObject.put("objectType", (Object)"LICENSE");
            return;
        }
        if (jsonObject.has("identifiableObjectType")) {
            jsonObject.put("objectType", (Object)"IDENTIFIABLE");
            return;
        }
        if (jsonObject.has("label") && jsonObject.has("namespace") && jsonObject.has("pattern")) {
            jsonObject.put("objectType", (Object)"IDENTIFIER_TYPE");
            return;
        }
        if (jsonObject.has("description") && jsonObject.has("label") && jsonObject.has("value")) {
            jsonObject.put("objectType", (Object)"PREDICATE");
            return;
        }
        if (jsonObject.has("label") && jsonObject.has("description") && jsonObject.has("name")) {
            jsonObject.put("objectType", (Object)"RENDERING_TEMPLATE");
            return;
        }
        if (jsonObject.has("email") && jsonObject.has("enabled") && jsonObject.has("passwordHash")) {
            jsonObject.put("objectType", (Object)"USER");
            return;
        }
        if (jsonObject.has("label") && jsonObject.has("locale")) {
            jsonObject.put("objectType", (Object)"HEADWORD");
            return;
        }
    }
}

