/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller;

import de.digitalcollections.cudami.server.business.api.service.UniqueObjectService;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ConflictException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.controller.AbstractPagingAndSortingController;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Order;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;

public abstract class AbstractUniqueObjectController<U extends UniqueObject>
extends AbstractPagingAndSortingController {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final Class<U> objectType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    protected long count() throws ServiceException {
        return this.getService().count();
    }

    protected ResponseEntity delete(UUID uuid) throws ConflictException, ServiceException {
        boolean successful;
        UniqueObject example = this.buildExampleWithUuid(uuid);
        try {
            successful = this.getService().delete(example);
        }
        catch (ServiceException e) {
            this.LOGGER.error("Cannot delete " + example.getClass().getSimpleName() + " with uuid=" + uuid + ": " + e, (Throwable)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return successful ? new ResponseEntity(HttpStatus.NO_CONTENT) : new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    protected ResponseEntity<Void> delete(List<UUID> uuids) throws ServiceException, ConflictException {
        this.getService().delete(uuids.stream().map(u -> {
            try {
                return this.buildExampleWithUuid(u);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toSet()));
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    protected abstract UniqueObjectService<U> getService();

    protected PageResponse<U> find(int pageNumber, int pageSize, List<Order> sortBy, List<FilterCriterion> filterCriteria, Filtering filtering) throws ServiceException {
        PageRequest pageRequest = this.createPageRequest(this.objectType, pageNumber, pageSize, sortBy, filterCriteria, filtering);
        return this.getService().find(pageRequest);
    }

    protected ResponseEntity<U> getByUuid(UUID uuid) throws ServiceException {
        UniqueObject result;
        return new ResponseEntity((Object)result, (result = this.getService().getByExample(this.buildExampleWithUuid(uuid))) != null ? HttpStatus.OK : HttpStatus.NOT_FOUND);
    }

    protected ResponseEntity<U> getByUuidAndLocale(UUID uuid, Locale locale) throws ServiceException {
        UniqueObject result;
        return new ResponseEntity((Object)result, (result = this.getService().getByExampleAndLocale(this.buildExampleWithUuid(uuid), locale)) != null ? HttpStatus.OK : HttpStatus.NOT_FOUND);
    }

    protected U save(U uniqueObject, BindingResult bindingResult) throws ValidationException, ServiceException {
        this.getService().save(uniqueObject);
        return uniqueObject;
    }

    protected U update(UUID uuid, U uniqueObject, BindingResult bindingResult) throws ValidationException, ServiceException {
        assert (Objects.equals(uuid, uniqueObject.getUuid()));
        this.getService().update(uniqueObject);
        return uniqueObject;
    }

    protected U buildExampleWithUuid(UUID uuid) throws ServiceException {
        try {
            UniqueObject example = (UniqueObject)this.objectType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            example.setUuid(uuid);
            return (U)example;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ServiceException("Cannot construct example " + this.objectType + " for uuid=" + uuid + ": " + e, (Throwable)e);
        }
    }
}

