/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.interceptors;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.MDC;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class RequestIdLoggingInterceptor
implements HandlerInterceptor {
    public void postHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, ModelAndView modelAndView) {
        MDC.clear();
    }

    @SuppressFBWarnings(value={"HRS_REQUEST_PARAMETER_TO_HTTP_HEADER"})
    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) {
        String requestId = request.getHeader("X-Request-Id");
        if (StringUtils.hasText((String)requestId)) {
            MDC.put((String)"request_id", (String)requestId);
            response.setHeader("X-Request-Id", requestId);
        }
        return true;
    }
}

