/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller;

import de.digitalcollections.cudami.server.business.api.service.LocaleService;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Locale;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Locale and language controller")
public class LocaleController {
    private final LocaleService localeService;

    public LocaleController(LocaleService localeService) {
        this.localeService = localeService;
    }

    @Operation(summary="Get default language")
    @GetMapping(value={"/v6/languages/default", "/v5/languages/default", "/v2/languages/default", "/latest/languages/default"}, produces={"application/json"})
    public ResponseEntity<Locale> getDefaultLanguage() throws ResourceNotFoundException {
        String defaultLanguage = this.localeService.getDefaultLanguage();
        if (defaultLanguage == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)new Locale(defaultLanguage), HttpStatus.OK);
    }

    @Operation(summary="Get default locale")
    @GetMapping(value={"/v6/locales/default", "/v5/locales/default", "/v2/locales/default", "/v1/locales/default", "/latest/locales/default"}, produces={"application/json"})
    public ResponseEntity<Locale> getDefaultLocale() throws ResourceNotFoundException {
        Locale defaultLocale;
        return new ResponseEntity((Object)defaultLocale, (defaultLocale = this.localeService.getDefaultLocale()) != null ? HttpStatus.OK : HttpStatus.NOT_FOUND);
    }

    @Operation(summary="Get all supported languages")
    @GetMapping(value={"/v6/languages", "/v5/languages", "/v2/languages", "/latest/languages"}, produces={"application/json"})
    public List<String> getSupportedLanguages() {
        return this.localeService.getSupportedLanguages();
    }

    @Operation(summary="Get all supported locales")
    @GetMapping(value={"/v6/locales", "/v5/locales", "/v2/locales", "/v1/locales", "/latest/locales"}, produces={"application/json"})
    public List<Locale> getSupportedLocales() {
        return this.localeService.getSupportedLocales();
    }
}

