/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.identifiable.entity.relation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.relation.EntityToEntityRelationService;
import de.digitalcollections.cudami.server.controller.legacy.model.LegacyFiltering;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Entity relation controller")
public class V3EntityRelationController {
    private final EntityToEntityRelationService entityRelationService;
    private final ObjectMapper objectMapper;

    public V3EntityRelationController(EntityToEntityRelationService entityRelationservice, ObjectMapper objectMapper) {
        this.entityRelationService = entityRelationservice;
        this.objectMapper = objectMapper;
    }

    @Operation(summary="Get filtered relations (deprecated, use /v5/entities/relations instead)", description="Get a paged, sorted and filtered list of relations", deprecated=true, responses={@ApiResponse(responseCode="200", description="PageResponse&lt;EntityRelation&gt; (<a href=\"https://raw.githubusercontent.com/dbmdz/digitalcollections-model/8.2.1/dc-model/src/main/java/de/digitalcollections/model/api/paging/PageResponse.java\">dc-model &lt; 9.0</a>)", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class), examples={@ExampleObject(name="example list", externalValue="https://github.com/dbmdz/cudami/raw/main/dc-cudami-server/dc-cudami-server-webapp/src/test/resources/json/v3/entities/relations.json")})})})
    @GetMapping(value={"/v3/entities/relations", "/latest/entities/relations"}, produces={"application/json"})
    public ResponseEntity<String> findByPredicate(@Parameter(name="pageNumber", description="the page number (starting with 0); if unset, defaults to 0.", example="0", schema=@Schema(type="integer")) @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @Parameter(name="pageSize", description="the page size; if unset, defaults to 25", example="25", schema=@Schema(type="integer")) @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @Parameter(name="predicate", description="the predicate, e.g. <tt>is_sponsored_by</tt>", example="is_sponsored_by", schema=@Schema(type="string")) @RequestParam(name="predicate", required=false) String predicate) throws JsonProcessingException, ServiceException {
        PageRequest pageRequest = new PageRequest(pageNumber, pageSize);
        if (StringUtils.hasText((String)predicate)) {
            Filtering filtering = Filtering.builder().add(FilterCriterion.builder().withExpression("predicate").isEquals((Object)predicate).build()).build();
            pageRequest.add(filtering);
        }
        PageResponse response = this.entityRelationService.find(pageRequest);
        JSONObject result = new JSONObject(this.objectMapper.writeValueAsString((Object)response));
        JSONArray websites = (JSONArray)result.get("content");
        for (JSONObject website : websites) {
            website.put("className", (Object)"de.digitalcollections.model.impl.identifiable.entity.relation.EntityRelationImpl");
        }
        JSONObject responsePageRequest = result.getJSONObject("pageRequest");
        responsePageRequest.put("filtering", (Object)new JSONObject(this.objectMapper.writeValueAsString((Object)new LegacyFiltering(((PageRequest)response.getRequest()).getFiltering()))));
        return new ResponseEntity((Object)result.toString(), HttpStatus.OK);
    }
}

