/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.legacy.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LegacyFiltering {
    private List<FilterCriterion> filterCriteria;

    public LegacyFiltering() {
        this.init();
    }

    public LegacyFiltering(List<FilterCriterion> filterCriteria) {
        this();
        this.filterCriteria = filterCriteria;
    }

    public LegacyFiltering(Filtering filtering) {
        this();
        this.init(filtering);
    }

    public List<FilterCriterion> add(LegacyFiltering filtering) {
        if (filtering == null || filtering.getFilterCriteria() == null) {
            return this.getFilterCriteria();
        }
        if (this.getFilterCriteria() == null) {
            this.setFilterCriteria(filtering.getFilterCriteria());
        } else {
            this.filterCriteria.addAll(filtering.getFilterCriteria());
        }
        return this.getFilterCriteria();
    }

    public void add(FilterCriterion filterCriterion) {
        if (this.filterCriteria == null) {
            this.filterCriteria = new ArrayList();
        }
        this.filterCriteria.add(filterCriterion);
    }

    public void add(String expression, FilterCriterion filterCriterion) {
        if (filterCriterion == null || expression == null) {
            return;
        }
        FilterCriterion filterCriterionWithExpression = new FilterCriterion(filterCriterion);
        filterCriterionWithExpression.setExpression(expression);
        this.filterCriteria.add(filterCriterionWithExpression);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LegacyFiltering)) {
            return false;
        }
        LegacyFiltering filtering = (LegacyFiltering)o;
        return Objects.equals(this.filterCriteria, filtering.filterCriteria);
    }

    public List<FilterCriterion> getFilterCriteria() {
        return this.filterCriteria;
    }

    public FilterCriterion getFilterCriterionFor(String property) {
        return this.filterCriteria.stream().filter(f -> f.getExpression().equals(property)).findFirst().orElse(null);
    }

    public int hashCode() {
        return Objects.hash(this.filterCriteria) + Objects.hash("Filtering");
    }

    protected void init() {
        if (this.filterCriteria == null) {
            this.filterCriteria = new ArrayList(0);
        }
    }

    private void init(Filtering filtering) {
        if (filtering == null || filtering.isEmpty()) {
            return;
        }
        filtering.stream().filter(fc -> fc != null).forEach(this.filterCriteria::add);
    }

    public void setFilterCriteria(List<FilterCriterion> filterCriteria) {
        this.filterCriteria = filterCriteria;
    }

    public String toString() {
        return "LegacyFiltering{filterCriteria=" + this.filterCriteria + "}";
    }
}

