/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.legal;

import de.digitalcollections.cudami.server.business.api.service.UniqueObjectService;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ConflictException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.business.api.service.legal.LicenseService;
import de.digitalcollections.cudami.server.controller.AbstractUniqueObjectController;
import de.digitalcollections.cudami.server.controller.editor.UrlEditor;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.legal.License;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Order;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.beans.PropertyEditor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="License controller")
public class LicenseController
extends AbstractUniqueObjectController<License> {
    private final LicenseService service;

    public LicenseController(LicenseService service) {
        this.service = service;
    }

    @Operation(summary="Get count of licenses")
    @GetMapping(value={"/v6/licenses/count", "/v5/licenses/count"}, produces={"application/json"})
    public long count() throws ServiceException {
        return super.count();
    }

    @Operation(summary="Delete license by given url")
    @DeleteMapping(value={"/v6/licenses", "/v5/licenses"}, params={"url"}, produces={"application/json"})
    public ResponseEntity<Void> deleteByUrl(@RequestParam(name="url", required=true) URL url) throws ServiceException {
        this.service.deleteByUrl(url);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @Operation(summary="Delete a license by uuid")
    @DeleteMapping(value={"/v6/licenses/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/v5/licenses/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"}, produces={"application/json"})
    public ResponseEntity<Void> deleteByUuid(@Parameter(example="", description="UUID of the license") @PathVariable(value="uuid") UUID uuid) throws ConflictException, ServiceException {
        return super.delete(uuid);
    }

    @Operation(summary="Delete licenses by given uuid list")
    @DeleteMapping(value={"/v6/licenses", "/v5/licenses"}, produces={"application/json"})
    public ResponseEntity<Void> deleteByUuids(@RequestBody List<UUID> uuids) throws ConflictException, ServiceException {
        return super.delete(uuids);
    }

    @Operation(summary="Get all licenses as (filtered, sorted, paged) list")
    @GetMapping(value={"/v6/licenses"}, produces={"application/json"})
    public PageResponse<License> find(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="sortBy", required=false) List<Order> sortBy, @RequestParam(name="filter", required=false) List<FilterCriterion> filterCriteria, @RequestParam(name="filtering", required=false) Filtering filtering) throws ServiceException {
        return super.find(pageNumber, pageSize, sortBy, filterCriteria, filtering);
    }

    @Operation(summary="Get all licenses in reduced form")
    @GetMapping(value={"/v6/licenses/all", "/v5/licenses/all"}, produces={"application/json"})
    public Set<License> getAll() throws ServiceException {
        return this.service.getAll();
    }

    @Operation(summary="Get a license by url")
    @GetMapping(value={"/v6/licenses", "/v5/licenses"}, params={"url"}, produces={"application/json"})
    public ResponseEntity<License> getByUrl(@RequestParam(name="url", required=true) URL url) throws MalformedURLException, ServiceException {
        License license;
        return new ResponseEntity((Object)license, (license = this.service.getByUrl(url)) != null ? HttpStatus.OK : HttpStatus.NOT_FOUND);
    }

    @Operation(summary="Get a license by uuid")
    @GetMapping(value={"/v6/licenses/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/v5/licenses/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"}, produces={"application/json"})
    public ResponseEntity<License> getByUuid(@PathVariable UUID uuid) throws ServiceException {
        return super.getByUuid(uuid);
    }

    @Operation(summary="Get languages of all licenses")
    @GetMapping(value={"/v6/licenses/languages"}, produces={"application/json"})
    public List<Locale> getLanguages() throws ServiceException {
        return this.service.getLanguages();
    }

    protected UniqueObjectService<License> getService() {
        return this.service;
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(URL.class, (PropertyEditor)new UrlEditor());
    }

    @Operation(summary="Save a newly created license")
    @PostMapping(value={"/v6/licenses", "/v5/licenses"}, produces={"application/json"})
    public License save(@RequestBody License license, BindingResult errors) throws ServiceException, ValidationException {
        return (License)super.save((UniqueObject)license, errors);
    }

    @Operation(summary="Update a license")
    @PutMapping(value={"/v6/licenses/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/v5/licenses/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"}, produces={"application/json"})
    public License update(@Parameter(example="", description="UUID of the license") @PathVariable(value="uuid") UUID uuid, @RequestBody License license, BindingResult errors) throws ServiceException, ValidationException {
        return (License)super.update(uuid, (UniqueObject)license, errors);
    }
}

