/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.identifiable.resource;

import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.FileResourceBinaryService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.FileResourceMetadataService;
import de.digitalcollections.model.file.MimeType;
import de.digitalcollections.model.identifiable.resource.FileResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.apache.tomcat.util.http.fileupload.FileItemIterator;
import org.apache.tomcat.util.http.fileupload.FileItemStream;
import org.apache.tomcat.util.http.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="File upload controller")
public class FileResourceBinaryController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileResourceBinaryController.class);
    private final FileResourceBinaryService binaryService;
    private final FileResourceMetadataService<FileResource> metadataService;

    public FileResourceBinaryController(FileResourceBinaryService binaryService, @Qualifier(value="fileResourceMetadataService") FileResourceMetadataService<FileResource> metadataService) {
        this.binaryService = binaryService;
        this.metadataService = metadataService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Save a file to the disk")
    @PostMapping(value={"/v6/files", "/v5/files", "/v2/files", "/latest/files"}, produces={"application/json"})
    public FileResource upload(HttpServletRequest request) throws IOException, ValidationException {
        FileResource fileResource = null;
        try (InputStream stream = null;){
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
            if (!isMultipart) {
                throw new InvalidObjectException("no multipart content");
            }
            ServletFileUpload upload = new ServletFileUpload();
            FileItemIterator iter = upload.getItemIterator(request);
            while (iter.hasNext()) {
                FileItemStream item = iter.next();
                if (item.isFormField()) continue;
                stream = item.openStream();
                String originalFilename = item.getName();
                originalFilename = URLDecoder.decode(originalFilename, StandardCharsets.UTF_8.toString());
                String contentType = item.getContentType();
                fileResource = this.metadataService.createByMimeType(MimeType.fromTypename((String)contentType));
                fileResource.setFilename(originalFilename);
                LOGGER.info("filename = " + fileResource.getFilename());
                this.binaryService.save(fileResource, stream);
                LOGGER.info("saved file '" + fileResource.getUri().toString() + "' (" + fileResource.getSizeInBytes() + " bytes)");
                stream.close();
            }
        }
        return fileResource;
    }
}

