/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.identifiable.entity.work;

import de.digitalcollections.cudami.server.business.api.service.exceptions.ConflictException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.DigitalObjectService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.EntityService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.work.ItemService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.work.WorkService;
import de.digitalcollections.cudami.server.controller.AbstractEntityController;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.identifiable.entity.digitalobject.DigitalObject;
import de.digitalcollections.model.identifiable.entity.item.Item;
import de.digitalcollections.model.identifiable.entity.work.Work;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Order;
import de.digitalcollections.model.list.sorting.Sorting;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Item controller")
public class ItemController
extends AbstractEntityController<Item> {
    private final DigitalObjectService digitalObjectService;
    private final ItemService service;
    private final WorkService workService;

    public ItemController(DigitalObjectService digitalObjectService, ItemService itemService, WorkService workService) {
        this.digitalObjectService = digitalObjectService;
        this.service = itemService;
        this.workService = workService;
    }

    @Operation(summary="Add digital object to an item")
    @PostMapping(value={"/v6/items/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/digitalobjects/{digitalObjectUuid}", "/v2/items/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/digitalobjects/{digitalObjectUuid}", "/latest/items/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/digitalobjects/{digitalObjectUuid}"}, produces={"application/json"})
    public ResponseEntity addDigitalObject(@Parameter(name="uuid", description="UUID of the item") @PathVariable UUID uuid, @Parameter(name="digitalObjectUuid", description="UUID of the digital object") @PathVariable UUID digitalObjectUuid) throws ValidationException, ConflictException, ServiceException {
        Item item = (Item)this.service.getByExample((UniqueObject)((Item)this.buildExampleWithUuid(uuid)));
        boolean successful = this.digitalObjectService.setItem(((DigitalObject.DigitalObjectBuilder)DigitalObject.builder().uuid(digitalObjectUuid)).build(), item);
        return successful ? new ResponseEntity(HttpStatus.NO_CONTENT) : new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @Operation(summary="count all items")
    @GetMapping(value={"/v6/items/count", "/v5/items/count", "/v2/items/count", "/latest/items/count"}, produces={"application/json"})
    public long count() throws ServiceException {
        return super.count();
    }

    @Operation(summary="Delete an item")
    @DeleteMapping(value={"/v6/items/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"}, produces={"application/json"})
    public ResponseEntity delete(@Parameter(example="", description="UUID of the item") @PathVariable(value="uuid") UUID uuid) throws ConflictException, ServiceException {
        return super.delete(uuid);
    }

    @Operation(summary="Get all items as (paged, sorted, filtered) list")
    @GetMapping(value={"/v6/items"}, produces={"application/json"})
    public PageResponse<Item> find(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="5") int pageSize, @RequestParam(name="sortBy", required=false) List<Order> sortBy, @RequestParam(name="filter", required=false) List<FilterCriterion> filterCriteria, @RequestParam(name="filtering", required=false) Filtering filtering) throws ServiceException {
        return super.find(pageNumber, pageSize, sortBy, filterCriteria, filtering);
    }

    @Operation(summary="Get paged list of digital objects of this item")
    @GetMapping(value={"/v6/items/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/digitalobjects"}, produces={"application/json"})
    public PageResponse<DigitalObject> findDigitalObjects(@Parameter(name="uuid", description="UUID of the item") @PathVariable UUID uuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="5") int pageSize, @RequestParam(name="sortBy", required=false) List<Order> sortBy) throws ServiceException {
        PageRequest pageRequest = new PageRequest(null, pageNumber, pageSize);
        if (sortBy != null) {
            Sorting sorting = new Sorting(sortBy);
            pageRequest.setSorting(sorting);
        }
        return this.digitalObjectService.findDigitalObjectsByItem((Item)this.buildExampleWithUuid(uuid), pageRequest);
    }

    @Operation(summary="Get an item by namespace and id", description="Separate namespace and id with a colon, e.g. foo:bar. It is also possible, to add a .json suffix, which will be ignored then")
    @GetMapping(value={"/v6/items/identifier/**", "/v5/items/identifier/**", "/v2/items/identifier/**", "/latest/items/identifier/**"}, produces={"application/json"})
    public ResponseEntity<Item> getByIdentifier(HttpServletRequest request) throws ServiceException, ValidationException {
        return super.getByIdentifier(request);
    }

    @Operation(summary="Get an item by namespace and id")
    @GetMapping(value={"/v6/items/identifier", "/v5/items/identifier", "/v2/items/identifier", "/latest/items/identifier"}, produces={"application/json"})
    public ResponseEntity<Void> getByIdentifier(@RequestParam(name="namespace", required=true) String namespace, @RequestParam(name="id", required=true) String id, HttpServletRequest request) throws ServiceException {
        URI newLocation = URI.create(request.getRequestURI().concat(String.format("/%s:%s", namespace, id)));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.MOVED_PERMANENTLY).location(newLocation)).build();
    }

    @Operation(summary="Get an item by uuid")
    @GetMapping(value={"/v6/items/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"}, produces={"application/json"})
    public ResponseEntity<Item> getByUuid(@Parameter(name="uuid", description="UUID of the item, e.g. <tt>599a120c-2dd5-11e8-b467-0ed5f89f718b</tt>") @PathVariable(value="uuid") UUID uuid, @Parameter(name="pLocale", description="Desired locale, e.g. <tt>de_DE</tt>. If unset, contents in all languages will be returned") @RequestParam(name="pLocale", required=false) Locale pLocale) throws ServiceException {
        if (pLocale == null) {
            return super.getByUuid(uuid);
        }
        return super.getByUuidAndLocale(uuid, pLocale);
    }

    @Operation(summary="Get a list of items by their UUIDs")
    @GetMapping(value={"/v6/items/list/{uuids}"}, produces={"application/json"})
    public PageResponse<Item> getByUuids(@PathVariable List<UUID> uuids) throws ServiceException {
        return super.getByUuids(uuids);
    }

    @Operation(summary="Get a list of items objects by UUID")
    @PostMapping(value={"/v6/items/list"}, produces={"application/json"})
    public PageResponse<Item> getByManyUuids(@RequestBody List<UUID> uuids) throws ServiceException {
        return super.getByUuids(uuids);
    }

    @Operation(summary="Get languages of all items", description="Get languages of all items", responses={@ApiResponse(responseCode="200", description="List&lt;Locale&gt;")})
    @GetMapping(value={"/v6/items/languages"}, produces={"application/json"})
    public List<Locale> getLanguages() throws ServiceException {
        return super.getLanguages();
    }

    @Operation(summary="Get languages of all items", description="Get languages of all items", responses={@ApiResponse(responseCode="200", description="List&lt;Locale&gt;")})
    @GetMapping(value={"/v6/items/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/digitalobjects/languages"}, produces={"application/json"})
    public List<Locale> getLanguagesOfDigitalObjects(@Parameter(name="uuid", description="UUID of the item") @PathVariable UUID uuid) throws ServiceException {
        return this.service.getLanguagesOfDigitalObjects((Item)this.buildExampleWithUuid(uuid));
    }

    protected EntityService<Item> getService() {
        return this.service;
    }

    @Operation(summary="Get the work embodied in an item")
    @GetMapping(value={"/v6/items/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/works", "/v2/items/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/works", "/latest/items/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/works"}, produces={"application/json"})
    public Set<Work> getWorks(@Parameter(name="uuid", description="UUID of the item") @PathVariable UUID uuid) throws ServiceException {
        return Set.of(this.workService.getByItem((Item)this.buildExampleWithUuid(uuid)));
    }

    @Operation(summary="Remove an existing parent item (attribute partOfItem) from an existing item")
    @DeleteMapping(value={"/v6/items/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/parent/{parentItemUuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"}, produces={"application/json"})
    public ResponseEntity removeParentItem(@Parameter(example="", description="UUID of the item") @PathVariable(value="uuid") UUID uuid, @Parameter(example="", description="UUID of the parent item") @PathVariable(value="parentItemUuid") UUID parentItemUuid) throws ServiceException {
        Item parentItem;
        Item item = (Item)this.buildExampleWithUuid(uuid);
        boolean successful = this.service.clearPartOfItem(item, parentItem = (Item)this.buildExampleWithUuid(parentItemUuid));
        return successful ? new ResponseEntity(HttpStatus.NO_CONTENT) : new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @Operation(summary="Remove the parent item relation(attribute partOfItem) from all of its children")
    @DeleteMapping(value={"/v6/items/{parentItemUuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/children/all"}, produces={"application/json"})
    public ResponseEntity removeAllChildrenOfParentItem(@Parameter(example="", description="UUID of the parent item") @PathVariable(value="parentItemUuid") UUID parentItemUuid) throws ServiceException {
        Item parentItem = (Item)this.buildExampleWithUuid(parentItemUuid);
        boolean successful = this.service.removeParentItemChildren(parentItem);
        return successful ? new ResponseEntity(HttpStatus.NO_CONTENT) : new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @Operation(summary="save a newly created item")
    @PostMapping(value={"/v6/items", "/v5/items", "/v2/items", "/latest/items"}, produces={"application/json"})
    public Item save(@RequestBody Item item, BindingResult errors) throws ServiceException, ValidationException {
        return (Item)super.save((UniqueObject)item, errors);
    }

    @Operation(summary="update an item")
    @PutMapping(value={"/v6/items/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/v5/items/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/v2/items/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/latest/items/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"}, produces={"application/json"})
    public Item update(@PathVariable(value="uuid") UUID uuid, @RequestBody Item item, BindingResult errors) throws ServiceException, ValidationException {
        return (Item)super.update(uuid, (UniqueObject)item, errors);
    }
}

