/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.relation;

import de.digitalcollections.cudami.server.business.api.service.UniqueObjectService;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ConflictException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.business.api.service.relation.PredicateService;
import de.digitalcollections.cudami.server.controller.AbstractUniqueObjectController;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Order;
import de.digitalcollections.model.relation.Predicate;
import de.digitalcollections.model.validation.ValidationError;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Predicate controller")
public class PredicateController
extends AbstractUniqueObjectController<Predicate> {
    private final PredicateService service;

    public PredicateController(PredicateService predicateService) {
        this.service = predicateService;
    }

    @DeleteMapping(value={"/v6/predicates/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    public ResponseEntity delete(@Parameter(example="", description="UUID of the predicate, e.g. <tt>599a120c-2dd5-11e8-b467-0ed5f89f718b</tt>") @PathVariable(value="uuid") UUID uuid) throws ConflictException, ServiceException {
        return super.delete(uuid);
    }

    @Operation(summary="Get all predicates as (paged, sorted, filtered) list")
    @GetMapping(value={"/v6/predicates"}, produces={"application/json"})
    public PageResponse<Predicate> find(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="sortBy", required=false) List<Order> sortBy, @RequestParam(name="filter", required=false) List<FilterCriterion> filterCriteria, @RequestParam(name="filtering", required=false) Filtering filtering) throws ServiceException {
        return super.find(pageNumber, pageSize, sortBy, filterCriteria, filtering);
    }

    @Operation(summary="Get a predicate by its value or UUID")
    @GetMapping(value={"/v6/predicates/{valueOrUuid:.+}"}, produces={"application/json"})
    public ResponseEntity<Predicate> getByValueOrUUID(@PathVariable(value="valueOrUuid") String valueOrUuid) throws ServiceException {
        Predicate result;
        if (valueOrUuid.matches("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$")) {
            UUID uuid = UUID.fromString(valueOrUuid);
            result = (Predicate)this.service.getByExample((UniqueObject)((Predicate)this.buildExampleWithUuid(uuid)));
        } else {
            result = this.service.getByValue(valueOrUuid);
        }
        return new ResponseEntity((Object)result, result != null ? HttpStatus.OK : HttpStatus.NOT_FOUND);
    }

    @Operation(summary="Get languages of all predicates")
    @GetMapping(value={"/v6/predicates/languages"}, produces={"application/json"})
    public List<Locale> getLanguages() throws ServiceException {
        return this.service.getLanguages();
    }

    protected UniqueObjectService<Predicate> getService() {
        return this.service;
    }

    @Operation(summary="Save a newly created predicate")
    @PostMapping(value={"/v6/predicates", "/v5/predicates", "/v3/predicates", "/latest/predicates"}, produces={"application/json"})
    public Predicate saveWithValidation(@Valid @RequestBody Predicate predicate, BindingResult bindingResult) throws ServiceException, de.digitalcollections.model.validation.ValidationException, ValidationException {
        if (bindingResult.hasErrors()) {
            de.digitalcollections.model.validation.ValidationException validationException = new de.digitalcollections.model.validation.ValidationException("validation error");
            bindingResult.getAllErrors().forEach(error -> {
                String fieldName = ((FieldError)error).getField();
                String errorMessage = error.getDefaultMessage();
                validationException.addError(new ValidationError(fieldName, errorMessage));
            });
            throw validationException;
        }
        return (Predicate)super.save((UniqueObject)predicate, bindingResult);
    }

    @Operation(summary="create or update a predicate, identified either by its value or by uuid")
    @PutMapping(value={"/v6/predicates/{valueOrUuid:.+}", "/v5/predicates/{valueOrUuid:.+}", "/v3/predicates/{valueOrUuid:.+}", "/latest/predicates/{valueOrUuid:.+}"}, produces={"application/json"})
    public Predicate update(@PathVariable(value="valueOrUuid") String valueOrUuid, @NotNull @RequestBody Predicate predicate) throws ServiceException, ValidationException {
        if (valueOrUuid.matches("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$")) {
            UUID uuid = UUID.fromString(valueOrUuid);
            if (!predicate.getUuid().equals(uuid)) {
                throw new IllegalArgumentException("path value of uuid=" + uuid + " does not match uuid of predicate=" + predicate.getUuid());
            }
            this.service.update((UniqueObject)predicate);
            return predicate;
        }
        String value = valueOrUuid;
        if (!value.matches(predicate.getValue())) {
            throw new IllegalArgumentException("value of path=" + value + " does not match value of predicate=" + predicate.getValue());
        }
        this.service.saveOrUpdate(predicate);
        return predicate;
    }
}

