/*
 * Decompiled with CFR 0.152.
 */
package de.eacg.ecs.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;

public class JsonCredentials {
    private final ObjectMapper mapper = new ObjectMapper();
    private final Map<String, Object> properties;

    public JsonCredentials(String filename) throws IOException {
        if (filename != null) {
            File f = new File(filename.replaceAll("^~", System.getProperty("user.home")));
            this.properties = (Map)this.mapper.readValue(f, Map.class);
        } else {
            this.properties = null;
        }
    }

    public JsonCredentials(File f) throws IOException {
        this.properties = (Map)this.mapper.readValue(f, Map.class);
    }

    public JsonCredentials(InputStream is) throws IOException {
        this.properties = (Map)this.mapper.readValue(is, Map.class);
    }

    public String getUser(String deflt) {
        String v = this.getString("userName");
        return v == null ? deflt : v;
    }

    public String getApiKey(String deflt) {
        String v = this.getString("apiKey");
        return v == null ? deflt : v;
    }

    public String getBasicAuthUser(String deflt) {
        Map sub = this.getType("basicAuth", Map.class);
        String v = JsonCredentials.getString(sub, "user");
        return v == null ? deflt : v;
    }

    public String getBasicAuthPasswd(String deflt) {
        Map sub = this.getType("basicAuth", Map.class);
        String v = JsonCredentials.getString(sub, "passwd");
        return v == null ? deflt : v;
    }

    private String getString(String key) {
        return JsonCredentials.getType(this.properties, key, String.class);
    }

    private static String getString(Map<String, Object> map, String key) {
        return JsonCredentials.getType(map, key, String.class);
    }

    private <T> T getType(String key, Class<T> type) {
        return JsonCredentials.getType(this.properties, key, type);
    }

    private static <T> T getType(Map<String, Object> map, String key, Class<T> type) {
        try {
            return map == null ? null : (T)type.cast(map.get(key));
        }
        catch (ClassCastException e) {
            return null;
        }
    }
}

