/*
 * Decompiled with CFR 0.152.
 */
package de.eacg.ecs.plugin;

import java.util.HashMap;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.project.MavenProject;

public class ProjectFix {
    private static final Map<String, String> lookup = new HashMap<String, String>();

    public static void fixProject(MavenProject model) {
        String[] parts;
        Artifact a = model.getArtifact();
        String str = String.format("%s:%s:%s:%s:%s", a.getGroupId(), a.getArtifactId(), a.getType(), a.hasClassifier() ? a.getClassifier() : "", a.getVersion());
        String fixed = lookup.get(str);
        if (fixed != null && (parts = fixed.split(":")).length == 5) {
            model.setGroupId(parts[0]);
            model.setArtifactId(parts[1]);
            model.setPackaging(parts[2]);
            model.setVersion(parts[4]);
            model.setArtifact((Artifact)new DefaultArtifact(parts[0], parts[1], parts[4], model.getArtifact().getScope(), parts[2], parts[3].isEmpty() ? null : parts[3], model.getArtifact().getArtifactHandler()));
        }
    }

    static {
        lookup.put("milyn:flute:jar::1.3", "org.milyn:flute:jar::1.3");
    }
}

