/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.builder;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemStackBuilder {
    private final ItemStack itemStack;

    private ItemStackBuilder(Material material, int amount) {
        this.itemStack = new ItemStack(material, amount);
    }

    public ItemStackBuilder(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public static ItemStackBuilder of(Material material) {
        return new ItemStackBuilder(material, 1);
    }

    public static ItemStackBuilder of(Material material, int amount) {
        return new ItemStackBuilder(material, amount);
    }

    public static ItemStackBuilder of(ItemStack stack) {
        return ItemStackBuilder.of(stack, true);
    }

    public static ItemStackBuilder of(ItemStack stack, boolean clone) {
        return new ItemStackBuilder(clone ? stack.clone() : stack);
    }

    public ItemStackBuilder withMetaValue(Consumer<@NotNull ItemMeta> itemMetaConsumer) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            itemMetaConsumer.accept(meta);
        }
        this.itemStack.setItemMeta(meta);
        return this;
    }

    public ItemStack build() {
        return this.itemStack.clone();
    }

    public ItemStackBuilder withEnchantments(@NotNull Map<Enchantment, Integer> enchantments) {
        this.itemStack.addEnchantments(enchantments);
        return this;
    }

    public ItemStackBuilder withEnchantment(@NotNull Enchantment ench, int level) {
        this.itemStack.addEnchantment(ench, level);
        return this;
    }

    public ItemStackBuilder withUnsafeEnchantments(@NotNull Map<Enchantment, Integer> enchantments) {
        this.itemStack.addUnsafeEnchantments(enchantments);
        return this;
    }

    public ItemStackBuilder withUnsafeEnchantment(@NotNull Enchantment ench, int level) {
        this.itemStack.addUnsafeEnchantment(ench, level);
        return this;
    }

    public ItemStackBuilder ofAmount(int amount) {
        this.itemStack.setAmount(amount);
        return this;
    }

    public ItemStackBuilder withDisplayName(@Nullable String name) {
        this.withMetaValue(m -> m.setDisplayName(name));
        return this;
    }

    public ItemStackBuilder withLocalizedName(@Nullable String name) {
        this.withMetaValue(m -> m.setLocalizedName(name));
        return this;
    }

    public ItemStackBuilder withLore(@Nullable List<String> lore) {
        this.withMetaValue(m -> m.setLore(lore));
        return this;
    }

    public ItemStackBuilder withLore(String ... lore) {
        return this.withLore(Arrays.asList(lore));
    }

    public ItemStackBuilder withCustomModelData(@Nullable Integer data) {
        this.withMetaValue(m -> m.setCustomModelData(data));
        return this;
    }

    public ItemStackBuilder withEnchant(@NotNull Enchantment ench, int level, boolean ignoreLevelRestriction) {
        this.withMetaValue(m -> m.addEnchant(ench, level, ignoreLevelRestriction));
        return this;
    }

    public ItemStackBuilder withItemFlags(ItemFlag ... itemFlags) {
        this.withMetaValue(m -> m.addItemFlags(itemFlags));
        return this;
    }

    public ItemStackBuilder asUnbreakable() {
        this.withMetaValue(m -> m.setUnbreakable(true));
        return this;
    }

    public ItemStackBuilder asBreakable() {
        this.withMetaValue(m -> m.setUnbreakable(false));
        return this;
    }

    public ItemStackBuilder withAttributeModifier(@NotNull Attribute attribute, @NotNull AttributeModifier modifier) {
        this.withMetaValue(m -> m.addAttributeModifier(attribute, modifier));
        return this;
    }

    public ItemStackBuilder withDurability(int damage) {
        this.withMetaValue(m -> {
            if (m instanceof Damageable) {
                ((Damageable)m).setDamage(damage);
            }
        });
        return this;
    }

    public ItemStackBuilder withNBTData(Consumer<@NotNull PersistentDataContainer> dataConsumer) {
        this.withMetaValue(m -> dataConsumer.accept(m.getPersistentDataContainer()));
        return this;
    }

    public <T extends ItemMeta> ItemStackBuilder withMetaValue(Class<T> clazz, Consumer<@NotNull T> consumer) {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        if (itemMeta != null && clazz.isAssignableFrom(itemMeta.getClass())) {
            consumer.accept(itemMeta);
        }
        this.itemStack.setItemMeta(itemMeta);
        return this;
    }
}

