/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.updater.butlerupdater;

import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import de.eldoria.eldoutilities.updater.DefaultUpdateResponse;
import de.eldoria.eldoutilities.updater.Updater;
import de.eldoria.eldoutilities.updater.butlerupdater.ButlerUpdateCheckResponse;
import de.eldoria.eldoutilities.updater.butlerupdater.ButlerUpdateData;
import de.eldoria.eldoutilities.utils.Plugins;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Optional;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;

public class ButlerUpdateChecker
extends Updater<DefaultUpdateResponse, ButlerUpdateData> {
    private ButlerUpdateCheckResponse response;

    public ButlerUpdateChecker(ButlerUpdateData data) {
        super(data);
    }

    @Override
    protected Optional<DefaultUpdateResponse> checkUpdate(ButlerUpdateData data) {
        String body;
        Plugin plugin = data.plugin();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("%s/api/v1/update/check?version%s&id=%s".formatted(data.host(), plugin.getDescription().getVersion(), data.butlerId()))).GET().header("Content-Type", "application/json; utf-8").header("Accept", "application/json").header("User-Agent", "EldoUtilities/ButlerUpdater").build();
        try {
            HttpResponse<String> response = this.client().send(request, HttpResponse.BodyHandlers.ofString());
            body = response.body();
            if (response.statusCode() != 200) {
                plugin.getLogger().log(Level.FINEST, "Received non 200 request.");
                return Optional.empty();
            }
        }
        catch (IOException e) {
            return Optional.empty();
        }
        catch (InterruptedException e) {
            return Optional.empty();
        }
        this.response = (ButlerUpdateCheckResponse)new Gson().fromJson(body, ButlerUpdateCheckResponse.class);
        return Optional.of(new DefaultUpdateResponse(this.response.isNewVersionAvailable(), this.response.latestVersion()));
    }

    @Override
    protected boolean update() {
        String hash;
        URL url;
        if (this.response == null) {
            return false;
        }
        Plugin plugin = ((ButlerUpdateData)this.getData()).plugin();
        plugin.getLogger().info("\u00a72>------------------------<");
        plugin.getLogger().info("\u00a72> Performing auto update <");
        plugin.getLogger().info("\u00a72>------------------------<");
        plugin.getLogger().info("\u00a72Performing auto update.");
        try {
            url = new URL(((ButlerUpdateData)this.getData()).host() + "/download?id=" + ((ButlerUpdateData)this.getData()).butlerId() + "&version=" + this.response.latestVersion());
        }
        catch (MalformedURLException e) {
            plugin.getLogger().log(Level.CONFIG, "Could not create download url.", e);
            plugin.getLogger().warning("\u00a7cAborting Update.");
            return false;
        }
        plugin.getLogger().info("\u00a72Downloaded new file.");
        String plugins = plugin.getDataFolder().getParent();
        File updateDirectory = new File(Paths.get(plugins, "update").toString());
        if (!updateDirectory.exists() && !updateDirectory.mkdirs()) {
            plugin.getLogger().warning("\u00a7cCould not create update directory.");
            plugin.getLogger().warning("\u00a7cAborting Update.");
            return false;
        }
        Optional pluginFile = Plugins.getPluginFile((Plugin)plugin);
        if (pluginFile.isEmpty()) {
            plugin.getLogger().log(Level.WARNING, "\u00a7cCould not find plugin file");
            return false;
        }
        File updateFile = Paths.get(updateDirectory.getAbsolutePath(), ((File)pluginFile.get()).getName()).toFile();
        try (InputStream input = url.openStream();){
            Files.copy(input, updateFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.WARNING, "Could not create update file.", e);
            plugin.getLogger().warning("\u00a7cAborting Update.");
            return false;
        }
        plugin.getLogger().info("\u00a72Calculate checksum.");
        try {
            hash = Hashing.sha256().hashBytes(Files.readAllBytes(updateFile.toPath())).toString();
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.WARNING, "Failed to create hash from update file.", e);
            plugin.getLogger().warning("\u00a7cAborting Update.");
            updateFile.delete();
            return false;
        }
        if (!hash.equals(this.response.hash())) {
            plugin.getLogger().warning("\u00a7cChecksums of update file is not as expected.");
            plugin.getLogger().warning("\u00a7cAborting Update.");
            updateFile.delete();
            return false;
        }
        plugin.getLogger().info("\u00a72Checksums of update file is correct.");
        plugin.getLogger().info("\u00a72File " + ((File)pluginFile.get()).getName() + " will be replaced with the new version on next startup.");
        plugin.getLogger().info("\u00a72>----------------------------------------------------<");
        plugin.getLogger().info("\u00a72> Update downloaded. Please restart to apply update. <");
        plugin.getLogger().info("\u00a72>----------------------------------------------------<");
        return true;
    }
}

