/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.updater;

import de.eldoria.eldoutilities.messages.MessageSender;
import de.eldoria.eldoutilities.updater.DefaultUpdateResponse;
import de.eldoria.eldoutilities.updater.UpdateData;
import de.eldoria.eldoutilities.updater.UpdateResponse;
import de.eldoria.eldoutilities.updater.butlerupdater.ButlerUpdateChecker;
import de.eldoria.eldoutilities.updater.butlerupdater.ButlerUpdateData;
import de.eldoria.eldoutilities.updater.lynaupdater.LynaUpdateChecker;
import de.eldoria.eldoutilities.updater.lynaupdater.LynaUpdateData;
import de.eldoria.eldoutilities.updater.lynaupdater.LynaUpdateResponse;
import de.eldoria.eldoutilities.updater.notifier.DownloadedNotifier;
import de.eldoria.eldoutilities.updater.notifier.UpdateNotifier;
import de.eldoria.eldoutilities.updater.spigotupdater.SpigotUpdateChecker;
import de.eldoria.eldoutilities.updater.spigotupdater.SpigotUpdateData;
import java.net.http.HttpClient;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public abstract class Updater<V extends UpdateResponse, T extends UpdateData<V>>
implements Listener,
Runnable {
    private final Plugin plugin;
    private final T data;
    private final HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r);
        thread.setName("EldoUtilititesUpdateChecker");
        thread.setDaemon(true);
        return thread;
    });
    private boolean notifyActive;
    private boolean updateAvailable;
    private boolean downloaded;
    private V lastCheck;

    protected Updater(T data) {
        this.plugin = ((UpdateData)data).plugin();
        this.data = data;
    }

    public static Updater<DefaultUpdateResponse, SpigotUpdateData> spigot(SpigotUpdateData data) {
        return new SpigotUpdateChecker(data);
    }

    @Deprecated
    public static Updater<DefaultUpdateResponse, ButlerUpdateData> butler(ButlerUpdateData data) {
        return new ButlerUpdateChecker(data);
    }

    public static Updater<LynaUpdateResponse, LynaUpdateData> lyna(LynaUpdateData data) {
        return new LynaUpdateChecker(data);
    }

    @Override
    public void run() {
        this.performCheck(true);
    }

    public final void performCheck(boolean silent) {
        Optional<V> optLatest;
        if (this.updateAvailable) {
            return;
        }
        if (!silent) {
            this.plugin.getLogger().info("Checking for new Version...");
        }
        if (!(optLatest = this.checkUpdate(this.data)).isPresent()) {
            this.plugin.getLogger().info("Could not check latest version.");
            return;
        }
        this.lastCheck = (UpdateResponse)optLatest.get();
        this.updateAvailable = ((UpdateResponse)optLatest.get()).isOutdated();
        if (this.updateAvailable) {
            this.logUpdateMessage();
            if (((UpdateData)this.data).isAutoUpdate()) {
                if (!this.downloaded) {
                    this.downloaded = this.update();
                }
                this.registerListener(new DownloadedNotifier<V>(this.plugin, this.data, this.lastCheck, this.downloaded));
            } else {
                this.registerListener(new UpdateNotifier<V>(this.plugin, this.data, this.lastCheck));
            }
        } else if (!silent) {
            this.plugin.getLogger().info("Plugin is up to date.");
        }
    }

    protected boolean update() {
        return false;
    }

    protected abstract Optional<V> checkUpdate(T var1);

    public void start() {
        this.executor.scheduleAtFixedRate(this, 0L, 6L, TimeUnit.HOURS);
    }

    private void logUpdateMessage() {
        ((UpdateData)this.data).updateMessage(this.lastCheck).lines().forEach(line -> {
            try {
                this.plugin.getLogger().info(MessageSender.getPluginMessageSender((Plugin)this.plugin).translatePlain(line, new TagResolver[0]));
            }
            catch (Throwable e) {
                this.plugin.getLogger().info(line.replaceAll("(\u00a7[0-9a-fklmnor])|(<+.?>)", ""));
            }
        });
    }

    private void registerListener(Listener listener) {
        if (((UpdateData)this.data).isNotifyUpdate() && !this.notifyActive) {
            this.notifyActive = true;
            this.plugin.getServer().getPluginManager().registerEvents(listener, this.plugin);
        }
    }

    public T getData() {
        return this.data;
    }

    protected HttpClient client() {
        return this.client;
    }
}

