/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.updater.notifier;

import de.eldoria.eldoutilities.messages.MessageSender;
import de.eldoria.eldoutilities.updater.UpdateData;
import de.eldoria.eldoutilities.updater.UpdateResponse;
import de.eldoria.eldoutilities.updater.notifier.UpdateNotifier;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;

public class DownloadedNotifier<T extends UpdateResponse>
extends UpdateNotifier<T> {
    private final boolean updated;

    public DownloadedNotifier(Plugin plugin, UpdateData<T> data, T latestVersion, boolean updated) {
        super(plugin, data, latestVersion);
        this.updated = updated;
    }

    @Override
    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        PluginDescriptionFile description = this.plugin.getDescription();
        if (event.getPlayer().isOp() || event.getPlayer().hasPermission(this.data.notifyPermission())) {
            if (this.updated) {
                MessageSender.getPluginMessageSender((Plugin)this.plugin).sendMessage((CommandSender)event.getPlayer(), "New version of \u00a7b" + this.plugin.getName() + "\u00a7r downloaded.\nNewest version: \u00a7a" + this.latest + "\u00a7r! Current version: \u00a7c" + description.getVersion() + "\u00a7r!\nRestart to apply update. Patchnotes can be found here: \u00a7b" + description.getWebsite(), new TagResolver[0]);
            } else {
                MessageSender.getPluginMessageSender((Plugin)this.plugin).sendMessage((CommandSender)event.getPlayer(), this.data.updateMessage(this.latest()), new TagResolver[0]);
            }
        }
    }
}

