/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.updater;

import de.eldoria.eldoutilities.updater.UpdateResponse;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.plugin.Plugin;

public abstract class UpdateData<T extends UpdateResponse> {
    private final String notifyPermission;
    private final boolean notifyUpdate;
    private final Plugin plugin;
    private final boolean autoUpdate;
    private final String updateUrl;
    private final String updateMessage;

    public UpdateData(Plugin plugin, String notifyPermission, boolean notifyUpdate, boolean autoUpdate, String updateUrl, String updateMessage) {
        this.plugin = plugin;
        this.notifyPermission = notifyPermission;
        this.notifyUpdate = notifyUpdate;
        this.autoUpdate = autoUpdate;
        this.updateUrl = updateUrl;
        this.updateMessage = updateMessage;
    }

    public String notifyPermission() {
        return this.notifyPermission;
    }

    public boolean isNotifyUpdate() {
        return this.notifyUpdate;
    }

    public Plugin plugin() {
        return this.plugin;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    protected Map<String, Object> replacements(T updateResponse) {
        HashMap<String, Object> replacements = new HashMap<String, Object>();
        replacements.put("plugin_name", this.plugin.getName());
        replacements.put("new_version", updateResponse.latestVersion());
        replacements.put("current_version", this.plugin.getDescription().getVersion());
        replacements.put("website", this.updateUrl);
        return replacements;
    }

    public String updateMessage(T updateResponse) {
        String message = this.updateMessage;
        for (Map.Entry<String, Object> entry : this.replacements(updateResponse).entrySet()) {
            message = message.replace("{%s}".formatted(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return message;
    }
}

