/*
 * Decompiled with CFR 0.152.
 */
package de.eleon.console.builder;

import com.google.common.collect.Iterables;
import de.eleon.console.builder.ConsoleReaderFactory;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import jline.console.ConsoleReader;
import jline.console.completer.AggregateCompleter;
import jline.console.completer.Completer;
import jline.console.history.FileHistory;
import jline.console.history.MemoryHistory;

class ConsoleReaderWrapper {
    private FileHistory history;
    private ConsoleReader consoleReader;

    public ConsoleReaderWrapper() {
        try {
            this.consoleReader = ConsoleReaderFactory.get();
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't create console", e);
        }
        this.init();
    }

    void init() {
        this.consoleReader.setPrompt("> ");
    }

    void enableHistoryFrom(String file) {
        try {
            Path directory = Paths.get(System.getProperty("user.home"), ".jline");
            Path historyFile = Paths.get(directory.toString(), file);
            if (!directory.toFile().exists()) {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
            if (!historyFile.toFile().exists()) {
                Files.createFile(historyFile, new FileAttribute[0]);
            }
            this.history = new FileHistory(historyFile.toFile());
            this.consoleReader.setHistory(this.history);
            this.consoleReader.setHistoryEnabled(true);
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't create history file", e);
        }
    }

    void disableHistory() {
        this.consoleReader.setHistory(new MemoryHistory());
        this.consoleReader.setHistoryEnabled(false);
    }

    public ConsoleReader getConsoleReader() {
        return this.consoleReader;
    }

    public void setConsoleReader(ConsoleReader consoleReader) {
        this.consoleReader = consoleReader;
    }

    public void print(CharSequence charSequence) {
        try {
            this.consoleReader.println(charSequence);
            this.consoleReader.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't write to console", e);
        }
    }

    public void print(Collection<? extends CharSequence> columns) {
        try {
            this.consoleReader.printColumns(columns);
            this.consoleReader.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't write columns to console", e);
        }
    }

    public void setCompleters(List<Completer> completers) {
        for (Completer completer : this.consoleReader.getCompleters()) {
            this.consoleReader.removeCompleter(completer);
        }
        if (Iterables.size(completers) > 1) {
            AggregateCompleter completer = new AggregateCompleter(completers);
            this.consoleReader.addCompleter(completer);
        }
        for (Completer completer : completers) {
            this.consoleReader.addCompleter(completer);
        }
    }

    public String getInput() {
        try {
            String ret = this.consoleReader.readLine();
            if (ret != null) {
                ret = ret.trim();
            }
            if (ret != null && !ret.isEmpty() && this.consoleReader.isHistoryEnabled() && this.history != null) {
                this.history.add(ret);
                this.history.flush();
            }
            return ret;
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't read from console", e);
        }
    }

    public void beep() {
        try {
            this.consoleReader.beep();
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't write to console", e);
        }
    }

    public void close() {
        this.consoleReader.shutdown();
    }
}

