/*
 * Decompiled with CFR 0.152.
 */
package de.eleon.console.builder.functional;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import de.eleon.console.builder.functional.Transformer;

public class Transformers {
    public static <T extends Enum<T>> Transformer<T> toEnum(final Class<T> enumClass) {
        return new Transformer<T>(){

            @Override
            public T apply(final String userIn) {
                Optional ret = FluentIterable.from(Lists.newArrayList(enumClass.getEnumConstants())).firstMatch(new Predicate<T>(){

                    @Override
                    public boolean apply(T enumValue) {
                        return ((Enum)enumValue).toString().equalsIgnoreCase(userIn);
                    }
                });
                if (!ret.isPresent()) {
                    throw new IllegalArgumentException(String.format("could not find value %s in enum %s", userIn, enumClass.getName()));
                }
                return (Enum)ret.get();
            }
        };
    }

    public static Transformer<Integer> toInteger() {
        return new Transformer<Integer>(){

            @Override
            public Integer apply(String userIn) {
                return Integer.parseInt(userIn.trim());
            }
        };
    }
}

