/*
 * Decompiled with CFR 0.152.
 */
package de.eleon.console.example;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import de.eleon.console.builder.ConsoleBuilder;
import de.eleon.console.builder.functional.Transformers;
import de.eleon.console.builder.functional.Validator;
import de.eleon.console.builder.functional.Validators;
import de.eleon.console.example.Person;
import java.io.IOException;
import jline.console.completer.StringsCompleter;

class Main {
    private Main() {
        String firstName = ConsoleBuilder.ask("Please enter your first name").validateWith(Validators.notEmpty("Empty String not allowed")).validateWith(Validators.regex("[a-zA-Z0-9\\-]{2,}", "Invalid format")).useHistory().answer();
        String lastName = ConsoleBuilder.ask("Please enter your last name").validateWith(Validators.notEmpty("Empty String not allowed")).validateWith(Validators.regex("[a-zA-Z0-9\\-]{2,}", "Invalid format")).useHistory().answer();
        Optional<String> company = ConsoleBuilder.ask("Please enter your company name").validateWith(Validators.regex("[a-zA-Z0-9\\-]{2,}", "Invalid format")).useHistory().optional().answer();
        Person.Gender gender = ConsoleBuilder.ask("Please enter your gender").answer(Person.Gender.class, "Please enter valid gender");
        String favoriteColor = ConsoleBuilder.ask("What ist your favorite color?").useHistoryFrom("color").answer();
        Integer age = (Integer)ConsoleBuilder.ask("how old are you?").completeWith(new StringsCompleter("22", "33", "44", "55", "66")).validateWith(this.validateAge("please enter valid age")).answer(Transformers.toInteger());
        ConsoleBuilder.print("First name " + firstName + ", last name " + lastName + ", company " + company.or("-") + ", gender " + (Object)((Object)gender) + ", favoriteColor " + favoriteColor + ", age " + age);
        ConsoleBuilder.newline();
        ConsoleBuilder.newline();
        ConsoleBuilder.print("Example creation of object with ");
        ConsoleBuilder.print(ImmutableList.of("name", "gender", "age"));
        ConsoleBuilder.print("Create person");
        Person person = new Person(ConsoleBuilder.ask("Please enter your first name").validateWith(Validators.notEmpty("Empty String not allowed")).answer(), ConsoleBuilder.ask("Please enter your gender").answer(Person.Gender.class, "Please enter valid gender"), (Integer)ConsoleBuilder.ask("how old are you?").answer(Transformers.toInteger()));
        ConsoleBuilder.print("person: " + person);
    }

    private Validator validateAge(final String message) {
        return new Validator(){

            @Override
            public boolean valid(String input) {
                Integer age = Integer.valueOf(input);
                return Range.closed(10, 99).contains(age);
            }

            @Override
            public String message() {
                return message;
            }
        };
    }

    public static void main(String[] args) throws IOException {
        new Main();
    }
}

