/*
 * Decompiled with CFR 0.152.
 */
package de.eleon.console.builder;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import de.eleon.console.builder.AnswerOptional;
import de.eleon.console.builder.ConsoleReaderWrapper;
import de.eleon.console.builder.functional.Transformers;
import de.eleon.console.builder.functional.Validator;
import de.eleon.console.builder.functional.Validators;
import java.util.List;
import jline.console.completer.Completer;
import jline.console.completer.EnumCompleter;

public class AskBuilder {
    private final String question;
    private final List<Validator> validators = Lists.newArrayList();
    private final List<Completer> completers = Lists.newArrayList();
    private Optional<String> history = Optional.absent();
    private boolean optional = false;

    static AskBuilder ask(String question) {
        return new AskBuilder(question);
    }

    private AskBuilder(String question) {
        this.question = question;
    }

    public AskBuilder validateWith(Validator validator) {
        this.validators.add(validator);
        return this;
    }

    public AskBuilder completeWith(Completer completer) {
        this.completers.add(completer);
        return this;
    }

    public AskBuilder useHistory() {
        this.history = Optional.of((Object)"history");
        return this;
    }

    public AskBuilder useHistoryFrom(String file) {
        this.history = Optional.of((Object)file);
        return this;
    }

    public AnswerOptional optional() {
        this.optional = true;
        return new AnswerOptional(this);
    }

    public String answer() {
        return this.initConsoleAndGetAnswer();
    }

    public <T> T answer(Function<String, T> function) {
        return this.answer(function, "unknown value");
    }

    public <T> T answer(Function<String, T> function, String validationErrorMessage) {
        this.validateWith(Validators.functionValidator(function, validationErrorMessage));
        return (T)function.apply((Object)this.answer());
    }

    public <T extends Enum<T>> T answer(Class<T> enumClass) {
        return this.answer(enumClass, "unknown value");
    }

    public <T extends Enum<T>> T answer(Class<T> enumClass, String validationErrorMessage) {
        this.validateWith(Validators.enumValidator(enumClass, validationErrorMessage));
        this.completeWith((Completer)new EnumCompleter(enumClass));
        return (T)((Enum)Transformers.toEnum(enumClass).apply(this.answer()));
    }

    private String initConsoleAndGetAnswer() {
        ConsoleReaderWrapper consoleReaderWrapper = this.initConsole();
        String input = "";
        boolean valid = false;
        while (!valid) {
            input = consoleReaderWrapper.getInput();
            valid = this.validate(consoleReaderWrapper, input);
            if (valid) continue;
            consoleReaderWrapper.print("");
            consoleReaderWrapper.print(this.question);
        }
        consoleReaderWrapper.close();
        return input;
    }

    private ConsoleReaderWrapper initConsole() {
        ConsoleReaderWrapper consoleReaderWrapper = new ConsoleReaderWrapper();
        consoleReaderWrapper.print("");
        consoleReaderWrapper.print(this.question);
        consoleReaderWrapper.setCompleters(this.completers);
        if (this.history.isPresent()) {
            consoleReaderWrapper.enableHistoryFrom((String)this.history.get());
        } else {
            consoleReaderWrapper.disableHistory();
        }
        return consoleReaderWrapper;
    }

    private boolean validate(ConsoleReaderWrapper consoleReaderWrapper, String input) {
        Iterable<String> errors = this.validate(input);
        if (!Iterables.isEmpty(errors)) {
            consoleReaderWrapper.beep();
            for (String error : errors) {
                consoleReaderWrapper.print(error);
            }
            return false;
        }
        return true;
    }

    private Iterable<String> validate(final String input) {
        if (this.optional && input.isEmpty()) {
            return Lists.newArrayList();
        }
        return FluentIterable.from(this.validators).filter((Predicate)new Predicate<Validator>(){

            public boolean apply(Validator validator) {
                try {
                    return !validator.valid(input);
                }
                catch (Exception e) {
                    return true;
                }
            }
        }).transform((Function)new Function<Validator, String>(){

            public String apply(Validator input) {
                return input.message();
            }
        });
    }
}

