/*
 * Decompiled with CFR 0.152.
 */
package de.eleon.console.builder.functional;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import de.eleon.console.builder.functional.Transformer;

public class Transformers {
    public static <T extends Enum<T>> Transformer<T> toEnum(final Class<T> enumClass) {
        return new Transformer<T>(){

            public T apply(final String userIn) {
                Optional ret = FluentIterable.from((Iterable)Lists.newArrayList((Object[])enumClass.getEnumConstants())).firstMatch(new Predicate<T>(){

                    public boolean apply(T enumValue) {
                        return ((Enum)enumValue).toString().equalsIgnoreCase(userIn);
                    }
                });
                if (!ret.isPresent()) {
                    throw new IllegalArgumentException(String.format("could not find value %s in enum %s", userIn, enumClass.getName()));
                }
                return (Enum)ret.get();
            }
        };
    }

    public static Transformer<Integer> toInteger() {
        return new Transformer<Integer>(){

            public Integer apply(String userIn) {
                return Integer.parseInt(userIn.trim());
            }
        };
    }
}

