/*
 * Decompiled with CFR 0.152.
 */
package de.eleon.console.builder.functional;

import com.google.common.base.Function;
import de.eleon.console.builder.functional.Transformers;
import de.eleon.console.builder.functional.Validator;

public class Validators {
    public static Validator notEmpty(final String message) {
        return new Validator(){

            @Override
            public boolean valid(String input) {
                return input != null && !input.isEmpty();
            }

            @Override
            public String message() {
                return message;
            }
        };
    }

    public static Validator regex(final String regex, final String message) {
        return new Validator(){

            @Override
            public boolean valid(String input) {
                return input != null && input.matches(regex);
            }

            @Override
            public String message() {
                return message;
            }
        };
    }

    public static <T extends Enum<T>> Validator enumValidator(final Class<T> enumClass, final String message) {
        return new Validator(){

            @Override
            public boolean valid(String input) {
                try {
                    Transformers.toEnum(enumClass).apply(input);
                    return true;
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }

            @Override
            public String message() {
                return message;
            }
        };
    }

    public static Validator functionValidator(final Function<String, ?> function, final String message) {
        return new Validator(){

            @Override
            public boolean valid(String input) {
                try {
                    function.apply((Object)input);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }

            @Override
            public String message() {
                return message;
            }
        };
    }
}

