/*
 * Decompiled with CFR 0.152.
 */
package de.elrebo.plugins;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="validate-dv2gen", defaultPhase=LifecyclePhase.VALIDATE)
public class ValidateDv2Gen
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)"ValidateDv2Gen.execute");
        try {
            this.transform("src/main/xml/RawVault.xml", "xslt/validate/consistency_checks.xslt", "target/temp/consistency_checks.xml");
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        try {
            this.transform("src/main/xml/RawVault.xml", "xslt/validate/pg_checks.xslt", "target/temp/pg_checks.xml");
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    private void transform(String xmlFile, String xsltFile, String outFile) throws TransformerException {
        this.getLog().debug((CharSequence)("  transform " + xmlFile + " mit " + xsltFile + " nach " + outFile));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        StreamSource xsltSource = new StreamSource(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(xsltFile));
        Transformer transformer = transformerFactory.newTransformer(xsltSource);
        StreamSource xmlSource = new StreamSource(xmlFile);
        StreamResult result = new StreamResult(outFile);
        transformer.transform(xmlSource, result);
    }
}

