<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <!--xmlns:fn="http://www.w3.org/2005/xpath-functions"
        xmlns:xs="http://www.w3.org/2001/XMLSchema"-->
    <xsl:output indent="yes"/>

    <xsl:template match="/raw_vault">
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
            <xsl:text>&#xA;    </xsl:text>
            <xsl:comment>DO NOT CHANGE THIS FILE! It is generated by gen_raw_vault.xslt</xsl:comment>
            <xsl:text>&#xA;    </xsl:text>
            <xsl:comment>Diese Datei ist generiert!</xsl:comment>
            <xsl:text>&#xA;    </xsl:text>
            <xsl:apply-templates select="node()"/>
            <xsl:apply-templates select="db_sources" mode="hub"/>
            <xsl:apply-templates select="db_sources" mode="link"/>
            <!--xsl:for-each select="document('../../xml/BusinessVault.xml')/business_vault">
                <xsl:copy>
                    <xsl:apply-templates select="@*|node()"/>
                </xsl:copy>
            </xsl:for-each-->
        </xsl:copy>
        <xsl:text>&#xA;</xsl:text>
    </xsl:template>

    <xsl:template match="db_sources" mode="hub">
            <hubs>
                <xsl:for-each select="db_source/table/stage/hub/nat_key">
                    <xsl:sort select="@idref"/>
                    <!--xsl:message>hub_<xsl:value-of select="@idref"/>:  <xsl:value-of select="../../@name"/>:  <xsl:value-of select="count(preceding::hub/nat_key[@idref = current()/@idref])"/></xsl:message-->
                    <xsl:if test="count(preceding::hub/nat_key[@idref = current()/@idref]) = 0">
                        <hub>
                            <xsl:variable name="name" select="concat('hub_', @idref)"/>
                            <xsl:attribute name="name" select="$name"/>
                            <xsl:attribute name="description" select="concat('Hub for Natural Key ', /raw_vault/nat_keys/nat_key[@id = current()/@idref]/@name)"/>
                            <stages>
                                <xsl:variable name="hub_id" select="@idref"/>
                                <xsl:for-each select="/raw_vault/db_sources/db_source/table/stage/hub[nat_key/@idref = $hub_id]">
                                    <stage>
                                        <xsl:attribute name="name" select="../@name"/>
                                        <xsl:for-each select="sat|ma_sat">
                                            <!--xsl:message><xsl:value-of select="local-name()"/><xsl:text> </xsl:text>aus Stage <xsl:value-of select="../../@name"/> und Hub hub_<xsl:value-of select="$hub_id"/><xsl:if test="@sat_suffix"><xsl:text> mit Suffix </xsl:text><xsl:value-of select="@sat_suffix"/></xsl:if></xsl:message-->
                                            <xsl:element name="{local-name()}">
                                                <xsl:attribute name="name">
                                                    <xsl:choose>
                                                        <xsl:when test="local-name() = 'ma_sat'">
                                                            <xsl:text>mas</xsl:text>
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <xsl:value-of select="local-name()"/>
                                                        </xsl:otherwise>
                                                    </xsl:choose>
                                                    <xsl:text>_</xsl:text>
                                                    <xsl:value-of select="../../@name"/>
                                                    <xsl:text>_hub_</xsl:text>
                                                    <xsl:value-of select="$hub_id"/>
                                                    <xsl:if test="@sat_suffix">
                                                        <xsl:text>_</xsl:text>
                                                        <xsl:value-of select="@sat_suffix"/>
                                                    </xsl:if>
                                                </xsl:attribute>
                                            </xsl:element>
                                        </xsl:for-each>
                                    </stage>
                                </xsl:for-each>

                            </stages>
                            <nat_key>
                                <xsl:attribute name="idref" select="@idref"/>
                            </nat_key>
                        </hub>
                    </xsl:if>
                </xsl:for-each>
            </hubs>
    </xsl:template>

    <xsl:template match="db_sources" mode="link">
        <links>
            <xsl:for-each select="db_source/table/stage/link">
                <xsl:sort>
                    <xsl:variable name="sorted_nat_key_idrefs">
                        <xsl:perform-sort select="nat_key">
                            <xsl:sort select="@idref"/>
                        </xsl:perform-sort>
                    </xsl:variable>
                    <xsl:value-of select="string-join($sorted_nat_key_idrefs, '_')"/>
                </xsl:sort>

                <!--xsl:message>Stage: <xsl:value-of select="@name"/></xsl:message-->
                <!--xsl:if test="$lag_sorted_nat_key_idrefs != $sorted_nat_key_idrefs"-->
                <!--xsl:message>Stage: <xsl:value-of select="@name"/></xsl:message-->
                <link>
                    <xsl:variable name="link_name" select="concat('link_', string-join(nat_key/@idref, '_'))"/>
                    <xsl:attribute name="name" select="$link_name"/>
                    <xsl:attribute name="prefix" select="concat('LINK_', upper-case(string-join(nat_key/@idref, '_')))"/>
                    <xsl:attribute name="description" select="concat('Link between Hubs hub_', string-join(nat_key/@idref, ', hub_'))"/>
                    <stages>
                        <xsl:variable name="link_id" select="string-join(nat_key/@idref, '_')"/>
                        <xsl:for-each select="/raw_vault/db_sources/db_source/table/stage/link[string-join(nat_key/@idref, '_') = $link_id]">
                            <stage>
                                <xsl:attribute name="name" select="../@name"/>
                                <xsl:for-each select="sat|ma_sat">
                                    <xsl:element name="{local-name()}">
                                        <xsl:attribute name="name">
                                            <xsl:choose>
                                                <xsl:when test="local-name() = 'ma_sat'">
                                                    <xsl:text>mas</xsl:text>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:value-of select="local-name()"/>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                            <xsl:text>_</xsl:text>
                                            <xsl:value-of select="../../@name"/>
                                            <xsl:text>_</xsl:text>
                                            <xsl:value-of select="$link_name"/>
                                            <xsl:if test="@sat_suffix">
                                                <xsl:text>_</xsl:text>
                                                <xsl:value-of select="@sat_suffix"/>
                                            </xsl:if>
                                        </xsl:attribute>
                                    </xsl:element>
                                </xsl:for-each>
                            </stage>
                        </xsl:for-each>
                    </stages>
                    <nat_keys>
                        <xsl:for-each select="nat_key">
                            <nat_key>
                                <xsl:attribute name="idref" select="@idref"/>
                            </nat_key>
                        </xsl:for-each>
                    </nat_keys>
                </link>
                <!--/xsl:if-->
            </xsl:for-each>
        </links>
    </xsl:template>

    <!--Identity template, kopiert alles unverändert -->
    <xsl:template match="@*|node()">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>
</xsl:stylesheet>
