/*
 * Decompiled with CFR 0.152.
 */
package de.elrebo;

import java.util.ArrayList;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.ItemTypeFactory;
import net.sf.saxon.s9api.OccurrenceIndicator;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;

public class XPathHelper {
    private final XPathExecutable xPathExecutable;
    private XPathSelector selector;

    public XPathHelper(Processor processor, String[][] namespaces, String[][] variables, String xPath) throws SaxonApiException {
        ItemTypeFactory itf = new ItemTypeFactory(processor);
        ArrayList<ItemType> types = new ArrayList<ItemType>();
        for (String[] variable : variables) {
            types.add(itf.getAtomicType(new QName("http://www.w3.org/2001/XMLSchema", variable[1])));
        }
        XPathCompiler xpathcompiler = processor.newXPathCompiler();
        for (int i = 0; i < variables.length; ++i) {
            xpathcompiler.declareVariable(new QName("", variables[i][0]), (ItemType)types.get(i), OccurrenceIndicator.ONE);
        }
        for (String[] namespace : namespaces) {
            xpathcompiler.declareNamespace(namespace[0], namespace[1]);
        }
        this.xPathExecutable = xpathcompiler.compile(xPath);
    }

    public void loadXPath() {
        this.selector = this.xPathExecutable.load();
    }

    public void setIntVariable(String name, int value) throws SaxonApiException {
        this.selector.setVariable(new QName("", name), (XdmValue)new XdmAtomicValue(value));
    }

    public void setDoubleVariable(String name, double value) throws SaxonApiException {
        this.selector.setVariable(new QName("", name), (XdmValue)new XdmAtomicValue(value));
    }

    public void setStringVariable(String name, String value) throws SaxonApiException {
        this.selector.setVariable(new QName("", name), (XdmValue)new XdmAtomicValue(value));
    }

    public XPathSelector setContextItem(XdmNode xdmNode) throws SaxonApiException {
        this.selector.setContextItem((XdmItem)xdmNode);
        return this.selector;
    }
}

