/*
 * Decompiled with CFR 0.152.
 */
package jade.content;

import jade.content.AgentAction;
import jade.content.OntoAID;
import jade.core.AID;
import jade.lang.acl.ACLMessage;
import jade.util.leap.Iterator;

public class OntoACLMessage
extends ACLMessage
implements AgentAction {
    public OntoACLMessage() {
        super(10);
    }

    public OntoACLMessage(int performative) {
        super(performative);
    }

    public static OntoACLMessage wrap(ACLMessage msg) {
        OntoACLMessage wrapper = null;
        if (msg != null) {
            if (msg instanceof OntoACLMessage) {
                wrapper = (OntoACLMessage)msg;
            } else {
                wrapper = new OntoACLMessage(msg.getPerformative());
                wrapper.setSender(msg.getSender());
                Iterator it = msg.getAllReceiver();
                while (it.hasNext()) {
                    wrapper.addReceiver((AID)it.next());
                }
                it = msg.getAllReplyTo();
                while (it.hasNext()) {
                    wrapper.addReplyTo((AID)it.next());
                }
                wrapper.setLanguage(msg.getLanguage());
                wrapper.setOntology(msg.getOntology());
                wrapper.setProtocol(msg.getProtocol());
                wrapper.setInReplyTo(msg.getInReplyTo());
                wrapper.setReplyWith(msg.getReplyWith());
                wrapper.setConversationId(msg.getConversationId());
                wrapper.setReplyByDate(msg.getReplyByDate());
                if (msg.hasByteSequenceContent()) {
                    wrapper.setByteSequenceContent(msg.getByteSequenceContent());
                } else {
                    wrapper.setContent(msg.getContent());
                }
                wrapper.setEncoding(msg.getEncoding());
            }
        }
        return wrapper;
    }

    @Override
    public void setSender(AID aid) {
        super.setSender(OntoAID.wrap(aid));
    }

    @Override
    public void addReceiver(AID aid) {
        super.addReceiver(OntoAID.wrap(aid));
    }

    @Override
    public void addReplyTo(AID aid) {
        super.addReplyTo(OntoAID.wrap(aid));
    }
}

