/*
 * Decompiled with CFR 0.152.
 */
package jade.content.lang.sl;

import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsConcept;
import jade.content.abs.AbsContentElement;
import jade.content.abs.AbsContentElementList;
import jade.content.abs.AbsHelper;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsPrimitive;
import jade.content.abs.AbsTerm;
import jade.content.abs.AbsVariable;
import jade.content.lang.Codec;
import jade.content.lang.StringCodec;
import jade.content.lang.sl.SLOntology;
import jade.content.lang.sl.SimpleSLTokenizer;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.ObjectSchema;
import jade.core.CaseInsensitiveString;
import jade.lang.acl.ISO8601;
import jade.util.Logger;
import jade.util.leap.Iterator;

public class SimpleSLCodec
extends StringCodec {
    private int indent = 0;
    private Logger logger = Logger.getMyLogger(this.getClass().getName());

    public SimpleSLCodec() {
        super("fipa-sl");
    }

    @Override
    public String encode(Ontology ontology, AbsContentElement content) throws Codec.CodecException {
        StringBuffer str = new StringBuffer("(");
        if (content instanceof AbsContentElementList) {
            Iterator i = ((AbsContentElementList)content).iterator();
            while (i.hasNext()) {
                AbsObject abs = (AbsObject)i.next();
                this.stringify(abs, ontology, str);
                str.append(" ");
            }
        } else {
            this.stringify(content, ontology, str);
        }
        str.append(")");
        return str.toString();
    }

    private void stringify(AbsObject val, Ontology onto, StringBuffer str) throws Codec.CodecException {
        if (val instanceof AbsPrimitive) {
            this.stringifyPrimitive((AbsPrimitive)val, str);
        } else if (val instanceof AbsVariable) {
            this.stringifyVariable((AbsVariable)val, str);
        } else if (val instanceof AbsAggregate) {
            this.stringifyAggregate((AbsAggregate)val, onto, str);
        } else {
            this.stringifyComplex(val, onto, str);
        }
    }

    private void stringifyComplex(AbsObject val, Ontology onto, StringBuffer str) throws Codec.CodecException {
        str.append("(");
        str.append(val.getTypeName());
        ObjectSchema s = null;
        try {
            s = onto.getSchema(val.getTypeName());
        }
        catch (OntologyException oe) {
            throw new Codec.CodecException("Error getting the schema for element " + val, oe);
        }
        if (val instanceof AbsConcept && !s.getEncodingByOrder()) {
            this.encodeSlotsByName(val, val.getNames(), onto, str);
        } else {
            this.encodeSlotsByOrder(val, s.getNames(), onto, str);
        }
        str.append(")");
    }

    private void encodeSlotsByOrder(AbsObject val, String[] slotNames, Ontology onto, StringBuffer str) throws Codec.CodecException {
        boolean lastSlotEmpty = false;
        for (int i = 0; i < slotNames.length; ++i) {
            AbsObject s = val.getAbsObject(slotNames[i]);
            if (s != null) {
                if (lastSlotEmpty) {
                    throw new Codec.CodecException("Non-empty slot " + slotNames[i] + " follows empty slot " + slotNames[i - 1]);
                }
                str.append(" ");
                this.stringify(s, onto, str);
                continue;
            }
            lastSlotEmpty = true;
        }
    }

    private void encodeSlotsByName(AbsObject val, String[] slotNames, Ontology onto, StringBuffer str) throws Codec.CodecException {
        for (int i = 0; i < slotNames.length; ++i) {
            AbsObject s = val.getAbsObject(slotNames[i]);
            if (s == null) continue;
            str.append(" :");
            str.append(slotNames[i]);
            str.append(" ");
            this.stringify(s, onto, str);
        }
    }

    private void stringifyAggregate(AbsAggregate val, Ontology onto, StringBuffer str) throws Codec.CodecException {
        str.append("(");
        str.append(val.getTypeName());
        Iterator i = val.iterator();
        while (i.hasNext()) {
            str.append(" ");
            this.stringify((AbsObject)i.next(), onto, str);
        }
        str.append(")");
    }

    private void stringifyVariable(AbsVariable val, StringBuffer str) throws Codec.CodecException {
        str.append("?");
        str.append(val.getName());
    }

    private void stringifyPrimitive(AbsPrimitive val, StringBuffer str) throws Codec.CodecException {
        String type = val.getTypeName();
        if (type.equals("BO_String")) {
            String s = val.getString();
            if (CaseInsensitiveString.equalsIgnoreCase("true", s) || CaseInsensitiveString.equalsIgnoreCase("false", s)) {
                s = '\"' + s + '\"';
            } else if (!SimpleSLTokenizer.isAWord(s)) {
                s = SimpleSLTokenizer.quoteString(s);
            }
            str.append(s);
        } else if (type.equals("BO_Date")) {
            str.append(ISO8601.toString(val.getDate()));
        } else {
            if (type.equals("BO_Byte-sequence")) {
                throw new Codec.CodecException("SL_does_not_allow_encoding_sequencesOfBytes");
            }
            str.append(val.getObject().toString());
        }
    }

    @Override
    public AbsContentElement decode(Ontology ontology, String content) throws Codec.CodecException {
        SimpleSLTokenizer p = new SimpleSLTokenizer(content);
        try {
            p.consumeChar('(');
            AbsContentElement abs = (AbsContentElement)this.parse(p, ontology);
            if (!p.nextToken().equals(")")) {
                AbsContentElementList l = new AbsContentElementList();
                l.add(abs);
                do {
                    AbsContentElement abs1 = (AbsContentElement)this.parse(p, ontology);
                    l.add(abs1);
                } while (!p.nextToken().equals(")"));
                abs = l;
            }
            p.consumeChar(')');
            return abs;
        }
        catch (ClassCastException cce) {
            throw new Codec.CodecException("Error converting to AbsContentElement", cce);
        }
    }

    public AbsObject decodeObject(Ontology ontology, String content) throws Codec.CodecException {
        SimpleSLTokenizer p = new SimpleSLTokenizer(content);
        try {
            return this.parse(p, ontology);
        }
        catch (ClassCastException cce) {
            throw new Codec.CodecException("Error converting to AbsContentElement", cce);
        }
    }

    private AbsObject parse(SimpleSLTokenizer p, Ontology o) throws Codec.CodecException {
        AbsObject abs = null;
        abs = p.isOpenBracket() ? this.parseComplex(p, o) : this.parseSimple(p);
        return abs;
    }

    private AbsObject parseComplex(SimpleSLTokenizer p, Ontology o) throws Codec.CodecException {
        AbsObject abs;
        block10: {
            abs = null;
            p.consumeChar('(');
            String name = p.getElement();
            if (this.logger.isLoggable(Logger.FINE)) {
                this.logger.log(Logger.FINE, "Parse complex descriptor: " + name);
            }
            ++this.indent;
            try {
                ObjectSchema s = o.getSchema(name);
                if (s != null) {
                    abs = s.newInstance();
                    if (abs instanceof AbsAggregate) {
                        this.fillAggregate((AbsAggregate)abs, p, o);
                    } else if (p.nextToken().startsWith(":")) {
                        this.fillSlotsByName((AbsConcept)abs, p, o);
                    } else {
                        this.fillSlotsByOrder(abs, s, p, o);
                    }
                    break block10;
                }
                throw new Codec.CodecException("No schema found for element " + name);
            }
            catch (Codec.CodecException ce) {
                throw ce;
            }
            catch (Throwable t) {
                throw new Codec.CodecException("Unexpeceted error parsing " + name, t);
            }
        }
        --this.indent;
        p.consumeChar(')');
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, abs.toString());
        }
        return abs;
    }

    private void fillSlotsByOrder(AbsObject abs, ObjectSchema s, SimpleSLTokenizer p, Ontology o) throws Codec.CodecException {
        String[] slotNames = s.getNames();
        int i = 0;
        while (!p.isClosedBracket()) {
            AbsObject val = this.parse(p, o);
            try {
                AbsHelper.setAttribute(abs, slotNames[i], val);
                ++i;
            }
            catch (OntologyException oe) {
                throw new Codec.CodecException("Can't assign " + val + " to slot " + slotNames[i] + " of " + abs);
            }
        }
    }

    private void fillSlotsByName(AbsConcept abs, SimpleSLTokenizer p, Ontology o) throws Codec.CodecException {
        while (!p.isClosedBracket()) {
            String slotName = p.getElement();
            try {
                AbsTerm val = (AbsTerm)this.parse(p, o);
                abs.set(slotName, val);
            }
            catch (ClassCastException cce) {
                throw new Codec.CodecException("Non Term value for slot " + slotName + " of Concept " + abs);
            }
        }
    }

    private void fillAggregate(AbsAggregate abs, SimpleSLTokenizer p, Ontology o) throws Codec.CodecException {
        int i = 0;
        while (!p.isClosedBracket()) {
            try {
                AbsTerm val = (AbsTerm)this.parse(p, o);
                abs.add(val);
                ++i;
            }
            catch (ClassCastException cce) {
                throw new Codec.CodecException("Non Term value for element " + i + " of Aggregate " + abs);
            }
        }
    }

    private AbsObject parseSimple(SimpleSLTokenizer p) throws Codec.CodecException {
        String val = p.getElement();
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Parse simple descriptor: " + val + ". Next is " + p.nextToken());
        }
        try {
            return AbsPrimitive.wrap(Long.parseLong(val));
        }
        catch (Exception exception) {
            try {
                return AbsPrimitive.wrap(Double.valueOf(val));
            }
            catch (Exception exception2) {
                try {
                    return AbsPrimitive.wrap(ISO8601.toDate(val));
                }
                catch (Exception exception3) {
                    if (val.equals("true")) {
                        return AbsPrimitive.wrap(true);
                    }
                    if (val.equals("false")) {
                        return AbsPrimitive.wrap(false);
                    }
                    if (val.startsWith("?")) {
                        return new AbsVariable(val.substring(1, val.length()), null);
                    }
                    if (val.startsWith("\"")) {
                        return AbsPrimitive.wrap(val.substring(1, val.length() - 1));
                    }
                    return AbsPrimitive.wrap(val);
                }
            }
        }
    }

    @Override
    public AbsContentElement decode(String content) throws Codec.CodecException {
        throw new Codec.CodecException("Unsupported operation");
    }

    @Override
    public String encode(AbsContentElement content) throws Codec.CodecException {
        throw new Codec.CodecException("Unsupported operation");
    }

    @Override
    public Ontology getInnerOntology() {
        return SLOntology.getInstance();
    }
}

