/*
 * Decompiled with CFR 0.152.
 */
package jade.content.lang.sl;

import jade.content.lang.Codec;

public class SimpleSLTokenizer {
    private static final String msg = "Parse error: unexpected end of content at #";
    private String content;
    private int current = 0;
    private static final String illegalFirstChar = "#0123456789:-?";

    public SimpleSLTokenizer(String s) {
        this.content = s;
    }

    public String nextToken() throws Codec.CodecException {
        try {
            this.skipSpaces();
            String token = null;
            char c = this.content.charAt(this.current);
            if (c == ')' || c == '(') {
                token = String.valueOf(c);
            } else {
                int start = this.current;
                token = this.getElement(false);
                this.current = start;
            }
            return token;
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new Codec.CodecException(msg + this.current);
        }
    }

    public boolean isOpenBracket() throws Codec.CodecException {
        try {
            this.skipSpaces();
            char c = this.content.charAt(this.current);
            return c == '(';
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new Codec.CodecException(msg + this.current);
        }
    }

    public boolean isClosedBracket() throws Codec.CodecException {
        try {
            this.skipSpaces();
            char c = this.content.charAt(this.current);
            return c == ')';
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new Codec.CodecException(msg + this.current);
        }
    }

    public void consumeChar(char c) throws Codec.CodecException {
        try {
            this.skipSpaces();
            if (this.content.charAt(this.current++) != c) {
                throw new Codec.CodecException("Parse error: position " + (this.current - 1) + ", found " + this.content.charAt(this.current - 1) + " while " + c + " was expected [" + this.content.substring(0, this.current) + "]");
            }
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new Codec.CodecException(msg + this.current);
        }
    }

    public String getElement() throws Codec.CodecException {
        return this.getElement(true);
    }

    private String getElement(boolean removeColon) throws Codec.CodecException {
        try {
            String el = null;
            this.skipSpaces();
            if (this.content.charAt(this.current) == '\"') {
                ++this.current;
                StringBuffer sb = new StringBuffer();
                while (this.content.charAt(this.current) != '\"') {
                    if (this.content.charAt(this.current) == '\\' && this.content.charAt(this.current + 1) == '\"') {
                        ++this.current;
                    }
                    sb.append(this.content.charAt(this.current));
                    ++this.current;
                }
                ++this.current;
                el = sb.toString();
            } else {
                el = this.getWord(removeColon);
            }
            return el;
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new Codec.CodecException(msg + this.current);
        }
    }

    private String getWord(boolean removeColon) {
        this.skipSpaces();
        int start = this.current;
        char c = this.content.charAt(this.current);
        if (removeColon && c == ':') {
            ++start;
        }
        while (!this.isSpace(c) && c != ')' && c != '(') {
            c = this.content.charAt(++this.current);
        }
        String s = this.content.substring(start, this.current);
        return s;
    }

    private void skipSpaces() {
        while (this.isSpace(this.content.charAt(this.current))) {
            ++this.current;
        }
    }

    private boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }

    public static final boolean isAWord(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        if (illegalFirstChar.indexOf(s.charAt(0)) >= 0) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '\"' && c != '(' && c != ')' && c > ' ' && c < '\u0080') continue;
            return false;
        }
        return true;
    }

    public static String quoteString(String s) {
        StringBuffer result = new StringBuffer(s.length() + 20);
        result.append("\"");
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\"') {
                result.append("\\\"");
                continue;
            }
            result.append(s.charAt(i));
        }
        result.append("\"");
        return result.toString();
    }
}

