/*
 * Decompiled with CFR 0.152.
 */
package jade.content.schema;

import jade.content.abs.AbsObject;
import jade.content.abs.AbsReference;
import jade.content.onto.BasicOntology;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.ObjectSchema;
import jade.content.schema.TermSchema;

public class ReferenceSchema
extends TermSchema {
    public static final String BASE_NAME = "Reference";
    private static ReferenceSchema baseSchema = new ReferenceSchema();
    public static final String NAME = "Name";
    public static final String OBJECT_TYPE = "ObjectType";

    private ReferenceSchema() {
        super(BASE_NAME);
        try {
            this.add(NAME, BasicOntology.getInstance().getSchema("BO_String"));
            this.add(OBJECT_TYPE, BasicOntology.getInstance().getSchema("BO_String"));
        }
        catch (OntologyException oe) {
            oe.printStackTrace();
        }
    }

    public static ObjectSchema getBaseSchema() {
        return baseSchema;
    }

    @Override
    public AbsObject newInstance() throws OntologyException {
        return new AbsReference();
    }

    @Override
    public void validate(AbsObject abs, Ontology onto) throws OntologyException {
        if (!(abs instanceof AbsReference)) {
            throw new OntologyException(abs + " is not an AbsReference");
        }
        this.validateSlots(abs, onto);
    }

    @Override
    public boolean isCompatibleWith(ObjectSchema s) {
        if (s != null) {
            return s.descendsFrom(TermSchema.getBaseSchema());
        }
        return false;
    }

    @Override
    protected boolean descendsFrom(ObjectSchema s) {
        if (s != null) {
            if (s.equals(ReferenceSchema.getBaseSchema())) {
                return true;
            }
            return super.descendsFrom(s);
        }
        return false;
    }
}

