/*
 * Decompiled with CFR 0.152.
 */
package jade.content.schema.facets;

import jade.content.abs.AbsObject;
import jade.content.abs.AbsPrimitive;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.Facet;

public class PermittedValuesFacet
implements Facet {
    private Object[] permittedValues;

    public PermittedValuesFacet(Object[] permittedValues) {
        this.permittedValues = permittedValues;
    }

    public Object[] getPermittedValues() {
        return this.permittedValues;
    }

    public String getPermittedValuesAsString() {
        StringBuilder sb = new StringBuilder();
        if (this.permittedValues != null) {
            for (int i = 0; i < this.permittedValues.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(this.permittedValues[i]);
            }
        }
        return sb.toString();
    }

    @Override
    public void validate(AbsObject value, Ontology onto) throws OntologyException {
        if (!(value instanceof AbsPrimitive)) {
            throw new OntologyException(value + " is not an AbsPrimitive");
        }
        AbsPrimitive absPrimitive = (AbsPrimitive)value;
        Object absValue = absPrimitive.getObject();
        if (absValue != null && this.permittedValues != null) {
            for (int i = 0; i < this.permittedValues.length; ++i) {
                if (!absValue.equals(this.permittedValues[i])) continue;
                return;
            }
            throw new OntologyException(value + " is not a permitted value (" + this.getPermittedValuesAsString() + ")");
        }
    }
}

