/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.CaseInsensitiveString;
import jade.lang.acl.StringACLCodec;
import jade.util.leap.ArrayList;
import jade.util.leap.Comparable;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Properties;
import jade.util.leap.Serializable;
import java.util.Enumeration;

public class AID
implements Comparable,
Serializable {
    public static final char HAP_SEPARATOR = '@';
    private static String platformID;
    private String name;
    private int hashCode;
    private static final int EXPECTED_ADDRESSES_SIZE = 1;
    private static final int EXPECTED_RESOLVERS_SIZE = 1;
    private List addresses = new ArrayList(1);
    private List resolvers = new ArrayList(1);
    private Properties userDefSlots = new Properties();
    public static final boolean ISGUID = true;
    public static final boolean ISLOCALNAME = false;
    public static final String AGENT_CLASSNAME = "JADE-agent-classname";
    public static final String CLONE_ORIGINATOR = "JADE-Clone-Originator";
    private transient Long persistentID;

    public AID() {
        this("", true);
    }

    public AID(String guid) {
        this(guid, true);
    }

    public AID(String name, boolean isGUID) {
        if (isGUID) {
            this.setName(name);
        } else {
            this.setLocalName(name);
        }
    }

    static final String getPlatformID() {
        return platformID;
    }

    static final void setPlatformID(String id) {
        platformID = id;
    }

    public void setName(String n) {
        this.name = n.trim();
        this.hashCode = this.name.toLowerCase().hashCode();
    }

    public void setLocalName(String n) {
        String hap = AID.getPlatformID();
        if (hap == null) {
            throw new RuntimeException("Unknown Platform Name");
        }
        this.name = n.trim();
        this.name = AID.createGUID(this.name, hap);
        this.hashCode = this.name.toLowerCase().hashCode();
    }

    public static String createGUID(String localName, String platformName) {
        String n = localName.trim();
        return n.concat('@' + platformName);
    }

    public String getName() {
        return this.name;
    }

    public void addAddresses(String url) {
        if (!this.addresses.contains(url)) {
            this.addresses.add(url);
        }
    }

    public boolean removeAddresses(String url) {
        return this.addresses.remove(url);
    }

    public void clearAllAddresses() {
        this.addresses.clear();
    }

    public Iterator getAllAddresses() {
        return this.addresses.iterator();
    }

    public void addResolvers(AID aid) {
        if (!this.resolvers.contains(aid)) {
            this.resolvers.add(aid);
        }
    }

    public boolean removeResolvers(AID aid) {
        return this.resolvers.remove(aid);
    }

    public void clearAllResolvers() {
        this.resolvers.clear();
    }

    public Iterator getAllResolvers() {
        return this.resolvers.iterator();
    }

    public void addUserDefinedSlot(String key, String value) {
        this.userDefSlots.setProperty(key, value);
    }

    public boolean removeUserDefinedSlot(String key) {
        return this.userDefSlots.remove(key) != null;
    }

    public String[] getAddressesArray() {
        Object[] objs = this.addresses.toArray();
        String[] result = new String[objs.length];
        System.arraycopy(objs, 0, result, 0, objs.length);
        return result;
    }

    private void setAddressesArray(String[] arr) {
        this.addresses.clear();
        for (int i = 0; i < arr.length; ++i) {
            this.addAddresses(arr[i]);
        }
    }

    public AID[] getResolversArray() {
        Object[] objs = this.resolvers.toArray();
        AID[] result = new AID[objs.length];
        System.arraycopy(objs, 0, result, 0, objs.length);
        return result;
    }

    private void setResolversArray(AID[] arr) {
        this.resolvers.clear();
        for (int i = 0; i < arr.length; ++i) {
            this.addResolvers(arr[i]);
        }
    }

    public Properties getAllUserDefinedSlot() {
        return this.userDefSlots;
    }

    public String toString() {
        int i;
        StringBuffer s = new StringBuffer("( agent-identifier ");
        StringACLCodec.appendACLExpression(s, ":name", this.name);
        if (this.addresses.size() > 0) {
            s.append(" :addresses (sequence ");
        }
        for (i = 0; i < this.addresses.size(); ++i) {
            try {
                s.append((String)this.addresses.get(i));
                s.append(" ");
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }
        if (this.addresses.size() > 0) {
            s.append(")");
        }
        if (this.resolvers.size() > 0) {
            s.append(" :resolvers (sequence ");
        }
        for (i = 0; i < this.resolvers.size(); ++i) {
            try {
                s.append(this.resolvers.get(i).toString());
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            s.append(" ");
        }
        if (this.resolvers.size() > 0) {
            s.append(")");
        }
        Enumeration<?> e = this.userDefSlots.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = this.userDefSlots.getProperty(key);
            s.append(" :X-");
            StringACLCodec.appendACLExpression(s, key, value);
        }
        s.append(")");
        return s.toString();
    }

    public synchronized Object clone() {
        AID result = new AID(this.name, true);
        result.persistentID = null;
        result.addresses = (ArrayList)((ArrayList)this.addresses).clone();
        result.resolvers = (ArrayList)((ArrayList)this.resolvers).clone();
        result.userDefSlots = (Properties)this.userDefSlots.clone();
        return result;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof AID) {
            return CaseInsensitiveString.equalsIgnoreCase(this.name, ((AID)o).name);
        }
        if (o instanceof String) {
            return CaseInsensitiveString.equalsIgnoreCase(this.name, (String)o);
        }
        return false;
    }

    public int compareTo(Object o) {
        AID id = (AID)o;
        return this.name.toLowerCase().toUpperCase().compareTo(id.name.toLowerCase().toUpperCase());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String getLocalName() {
        int atPos = this.name.lastIndexOf(64);
        if (atPos == -1) {
            return this.name;
        }
        return this.name.substring(0, atPos);
    }

    public String getHap() {
        int atPos = this.name.lastIndexOf(64);
        if (atPos == -1) {
            return null;
        }
        return this.name.substring(atPos + 1);
    }

    private Long getPersistentID() {
        return this.persistentID;
    }

    private void setPersistentID(Long l) {
        this.persistentID = l;
    }
}

