/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.BackEnd;
import jade.core.FEConnectionManager;
import jade.core.FrontEndContainer;
import jade.core.IMTPException;
import jade.core.NotFoundException;
import jade.core.ServiceException;
import jade.core.Specifier;
import jade.lang.acl.ACLMessage;
import jade.security.JADESecurityException;
import jade.util.leap.Properties;
import java.util.Enumeration;
import java.util.Vector;

class BackEndWrapper
implements BackEnd {
    private static final String CONN_MGR_CLASS_DEFAULT = "jade.imtp.leap.JICP.BIFEDispatcher";
    private FrontEndContainer myContainer;
    private Properties properties;
    private FEConnectionManager connectionManager;
    private BackEnd backEnd;

    BackEndWrapper(FrontEndContainer fec, Properties pp) throws Exception {
        this.myContainer = fec;
        this.properties = pp;
        String connMgrClass = this.properties.getProperty("connection-manager");
        if (connMgrClass == null) {
            connMgrClass = CONN_MGR_CLASS_DEFAULT;
        }
        this.connectionManager = (FEConnectionManager)Class.forName(connMgrClass).newInstance();
        if (this.properties.getProperty("platform-id") != null) {
            String containerName = this.properties.getProperty("msisdn");
            if (containerName == null && (containerName = this.properties.getProperty("container-name")) == null) {
                containerName = "_UNKNOWN_";
            }
            this.properties.put("container-name", containerName);
            String agents = this.properties.getProperty("agents");
            try {
                Vector specs = Specifier.parseSpecifierList(agents);
                Enumeration e = specs.elements();
                while (e.hasMoreElements()) {
                    Specifier sp = (Specifier)e.nextElement();
                    sp.setClassName(sp.getName());
                    sp.setArgs(null);
                }
                this.properties.put("agents", Specifier.encodeSpecifierList(specs));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.properties.put("mediator-id", this.properties.getProperty("container-name"));
            this.myContainer.initInfo(this.properties);
        } else {
            this.attach();
        }
    }

    @Override
    public String bornAgent(String name) throws IMTPException, JADESecurityException {
        if (this.backEnd != null) {
            return this.backEnd.bornAgent(name);
        }
        return name;
    }

    @Override
    public void deadAgent(String name) throws IMTPException {
        if (this.backEnd != null) {
            this.backEnd.deadAgent(name);
        }
    }

    @Override
    public void suspendedAgent(String name) throws NotFoundException, IMTPException {
        if (this.backEnd != null) {
            this.backEnd.suspendedAgent(name);
        }
    }

    @Override
    public void resumedAgent(String name) throws NotFoundException, IMTPException {
        if (this.backEnd != null) {
            this.backEnd.resumedAgent(name);
        }
    }

    @Override
    public void messageOut(ACLMessage msg, String sender) throws NotFoundException, IMTPException {
        if (this.backEnd == null) {
            this.attach();
        }
        this.backEnd.messageOut(msg, sender);
    }

    @Override
    public Object serviceInvokation(String actor, String serviceName, String methodName, Object[] methodParams) throws NotFoundException, ServiceException, IMTPException {
        if (this.backEnd == null) {
            this.attach();
        }
        return this.backEnd.serviceInvokation(actor, serviceName, methodName, methodParams);
    }

    void detach() {
        if (this.backEnd != null) {
            this.connectionManager.shutdown();
            this.backEnd = null;
        }
    }

    private void attach() throws IMTPException {
        this.backEnd = this.connectionManager.getBackEnd(this.myContainer, this.properties);
        this.myContainer.initInfo(this.properties);
    }
}

