/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.CallbackInvokator;
import jade.core.CommandProcessor;
import jade.core.Filter;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.IMTPManager;
import jade.core.Node;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.ServiceFinder;
import jade.core.ServiceHelper;
import jade.core.Sink;
import jade.core.VerticalCommand;
import jade.core.behaviours.Behaviour;
import jade.util.Logger;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.Map;

public abstract class BaseService
implements Service {
    public static final String MAIN_SLICE = "$$$Main-Slice$$$";
    public static final String THIS_SLICE = "$$$This-Slice$$$";
    public static final String ALL_DUMP_KEY = "ALL";
    private IMTPManager myIMTPManager;
    private CommandProcessor myCommandProcessor = null;
    private Map slices;
    private Map aliases;
    protected ServiceFinder myFinder;
    protected transient Logger myLogger = Logger.getMyLogger(this.getName());

    @Override
    public void init(AgentContainer ac, Profile p) throws ProfileException {
        this.myFinder = p.getServiceFinder();
        this.myIMTPManager = p.getIMTPManager();
        this.slices = new HashMap(5);
        this.aliases = new HashMap(1);
        this.myLogger.log(Logger.INFO, "Service " + this.getName() + " initialized");
    }

    void setCommandProcessor(CommandProcessor cp) {
        if (this.myCommandProcessor == null) {
            this.myCommandProcessor = cp;
        }
    }

    @Override
    public Service.Slice getSlice(String name) throws ServiceException {
        String realName = this.lookupAlias(name);
        Service.Slice s = (Service.Slice)this.slices.get(realName);
        if (s == null) {
            try {
                s = this.myFinder.findSlice(this.getName(), realName);
                this.slices.put(realName, s);
            }
            catch (IMTPException imtpe) {
                throw new ServiceException("IMTP Error while using the Service Finder", imtpe);
            }
        }
        return s;
    }

    @Override
    public int getNumberOfSlices() {
        return this.slices.size();
    }

    public Node getLocalNode() throws IMTPException {
        return this.myIMTPManager.getLocalNode();
    }

    @Override
    public Service.Slice[] getAllSlices() throws ServiceException {
        try {
            return this.myFinder.findAllSlices(this.getName());
        }
        catch (IMTPException imtpe) {
            throw new ServiceException("IMTP Error while using the Service Finder", imtpe);
        }
    }

    public void broadcast(HorizontalCommand cmd, boolean includeMyself) throws IMTPException, ServiceException {
        Service.Slice[] slices = this.myFinder.findAllSlices(this.getName());
        String localNodeName = this.getLocalNode().getName();
        for (int i = 0; i < slices.length; ++i) {
            Service.Slice s = slices[i];
            String sliceName = s.getNode().getName();
            if (!includeMyself && sliceName.equals(localNodeName)) continue;
            s.serve(cmd);
            Object ret = cmd.getReturnValue();
            if (!(ret instanceof Throwable)) continue;
            this.myLogger.log(Logger.WARNING, "Error propagating H-command " + cmd.getName() + " to slice " + sliceName, (Throwable)ret);
        }
    }

    protected void addAlias(String alias, String name) {
        this.aliases.put(alias, name);
    }

    protected String lookupAlias(String alias) {
        String result = (String)this.aliases.get(alias);
        if (result != null) {
            return result;
        }
        return alias;
    }

    @Override
    public Filter getCommandFilter(boolean direction) {
        return null;
    }

    @Override
    public Sink getCommandSink(boolean direction) {
        return null;
    }

    @Override
    public String[] getOwnedCommands() {
        return null;
    }

    @Override
    public Class getHorizontalInterface() {
        return null;
    }

    @Override
    public Service.Slice getLocalSlice() {
        return null;
    }

    public boolean isLocal() {
        return false;
    }

    @Override
    public ServiceHelper getHelper(Agent a) throws ServiceException {
        return null;
    }

    @Override
    public Behaviour getAMSBehaviour() {
        return null;
    }

    @Override
    public void boot(Profile p) throws ServiceException {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public Object submit(VerticalCommand cmd) throws ServiceException {
        String cmdName = cmd.getName();
        String[] ownedCommands = this.getOwnedCommands();
        for (int i = 0; i < ownedCommands.length; ++i) {
            if (!cmdName.equals(ownedCommands[i])) continue;
            return this.myCommandProcessor.processOutgoing(cmd);
        }
        throw new ServiceException("Command <" + cmdName + "> does not belong to service <" + this.getName() + ">");
    }

    protected Service.Slice getFreshSlice(String name) throws ServiceException {
        this.clearCachedSlice(name);
        return this.getSlice(name);
    }

    protected IMTPManager getIMTPManager() {
        return this.myIMTPManager;
    }

    protected void clearCachedSlice(String name) {
        if (this.slices != null) {
            String realName = this.lookupAlias(name);
            this.slices.remove(realName);
        }
    }

    public String dump(String key) {
        if (key == null || key.equals(ALL_DUMP_KEY)) {
            StringBuffer sb = new StringBuffer("LOCAL: ").append(this.isLocal()).append('\n');
            sb.append("CACHED SLICES:\n");
            Iterator it = this.slices.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                sb.append("- ").append(name).append(" --> " + BaseService.stringifySlice((Service.Slice)this.slices.get(name))).append("\n");
            }
            return sb.toString();
        }
        return "";
    }

    public static final String stringifySlice(Service.Slice s) {
        StringBuffer sb = new StringBuffer("SLICE ");
        try {
            sb.append(s.getClass().getName()).append(": node = " + s.getNode().getName());
        }
        catch (ServiceException se) {
            se.printStackTrace();
        }
        return sb.toString();
    }

    protected CallbackInvokator createInvokator() {
        return new CallbackInvokator();
    }
}

