/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.Agent;
import jade.core.MessageQueue;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.Logger;
import jade.util.leap.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class ExtendedMessageQueue
implements MessageQueue {
    protected LinkedList<ACLMessage> list;
    protected int maxSize;
    protected int warningLimit;
    protected MessageTemplate warningDiscardTemplate;
    protected Agent myAgent;
    protected Logger myLogger = Logger.getJADELogger(this.getClass().getName());

    public ExtendedMessageQueue(int maxSize, int warningLimit, MessageTemplate warningDiscardTemplate, Agent a) {
        this.maxSize = maxSize;
        this.warningLimit = warningLimit;
        this.warningDiscardTemplate = warningDiscardTemplate;
        this.myAgent = a;
        this.list = new LinkedList();
    }

    public ExtendedMessageQueue() {
        this(0, 0, null, null);
    }

    @Override
    public void setMaxSize(int maxSize) throws IllegalArgumentException {
        if (maxSize < 0) {
            maxSize = 0;
        }
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void addFirst(ACLMessage msg) {
        if (this.maxSize != 0 && this.size() >= this.maxSize) {
            ACLMessage discardedMsg = this.list.removeLast();
            this.handleDiscarded(discardedMsg, false);
        }
        this.list.addFirst(msg);
    }

    @Override
    public void addLast(ACLMessage msg) {
        if (this.maxSize != 0 && this.size() >= this.maxSize) {
            this.handleDiscarded(msg, false);
            return;
        }
        if (this.warningLimit > 0 && this.size() >= this.warningLimit && this.warningDiscardTemplate != null && this.warningDiscardTemplate.match(msg)) {
            this.handleDiscarded(msg, true);
            return;
        }
        this.list.addLast(msg);
    }

    protected void handleDiscarded(ACLMessage msg, boolean warningLimitExceeded) {
        if (warningLimitExceeded) {
            this.myLogger.log(Logger.SEVERE, "Agent " + this.getAgentName() + " - Message queue warning-limit exceeded. Message " + msg.shortToString() + " discarded!!!!!");
        } else {
            this.myLogger.log(Logger.SEVERE, "Agent " + this.getAgentName() + " - Message queue max-size exceeded. Message " + msg.shortToString() + " discarded!!!!!");
        }
    }

    @Override
    public ACLMessage receive(MessageTemplate pattern) {
        ACLMessage result = null;
        Iterator messages = this.list.iterator();
        while (messages.hasNext()) {
            ACLMessage msg = (ACLMessage)messages.next();
            if (pattern != null && !pattern.match(msg)) continue;
            messages.remove();
            result = msg;
            break;
        }
        return result;
    }

    @Override
    public java.util.List<ACLMessage> receive(MessageTemplate pattern, int max) {
        ArrayList<ACLMessage> mm = null;
        int cnt = 0;
        Iterator messages = this.list.iterator();
        while (messages.hasNext()) {
            ACLMessage msg = (ACLMessage)messages.next();
            if (pattern != null && !pattern.match(msg)) continue;
            messages.remove();
            if (mm == null) {
                mm = new ArrayList<ACLMessage>(max > 0 ? max : 16);
            }
            mm.add(msg);
            if (++cnt != max) continue;
            break;
        }
        return mm;
    }

    @Override
    public void copyTo(List messages) {
        Iterator i = this.list.iterator();
        while (i.hasNext()) {
            messages.add(i.next());
        }
    }

    private String getAgentName() {
        return this.myAgent != null ? this.myAgent.getLocalName() : "null";
    }

    public String dump(int limit) {
        if (limit <= 0) {
            limit = 100;
        }
        StringBuilder sb = new StringBuilder();
        Object[] messages = this.list.toArray();
        if (messages.length > 0) {
            int max = limit > 0 && limit < messages.length ? limit : messages.length;
            int cnt = 0;
            for (int j = 0; j < max; ++j) {
                sb.append("Message # ");
                sb.append(j);
                sb.append('\n');
                sb.append(messages[j]);
                sb.append('\n');
                ++cnt;
            }
            if (cnt < messages.length) {
                sb.append(".......\n");
                sb.append(String.valueOf(messages.length) + " messages in total\n");
            }
        } else {
            sb.append("Queue is empty\n");
        }
        return sb.toString();
    }
}

