/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.Agent;
import jade.core.MessageQueue;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.Logger;
import jade.util.leap.Iterator;
import jade.util.leap.LinkedList;
import jade.util.leap.List;
import java.util.ArrayList;

class InternalMessageQueue
implements MessageQueue {
    private LinkedList list;
    private int maxSize;
    private Agent myAgent;
    private Logger myLogger = Logger.getJADELogger(this.getClass().getName());
    private Long persistentID;

    public InternalMessageQueue(int size, Agent a) {
        this.maxSize = size;
        this.myAgent = a;
        this.list = new LinkedList();
    }

    public InternalMessageQueue() {
        this(0, null);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public void setMaxSize(int newSize) throws IllegalArgumentException {
        if (newSize < 0) {
            throw new IllegalArgumentException("Invalid MsgQueue size");
        }
        this.maxSize = newSize;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public void addFirst(ACLMessage msg) {
        if (this.maxSize != 0 && this.list.size() >= this.maxSize) {
            this.list.removeFirst();
        }
        this.list.addFirst(msg);
    }

    @Override
    public void addLast(ACLMessage msg) {
        if (this.maxSize != 0 && this.list.size() >= this.maxSize) {
            this.list.removeFirst();
            this.myLogger.log(Logger.SEVERE, "Agent " + this.getAgentName() + " - Message queue size exceeded. Message discarded!!!!!");
        }
        this.list.addLast(msg);
    }

    private String getAgentName() {
        return this.myAgent != null ? this.myAgent.getLocalName() : "null";
    }

    @Override
    public ACLMessage receive(MessageTemplate pattern) {
        ACLMessage result = null;
        int cnt = 0;
        Iterator messages = this.iterator();
        while (messages.hasNext()) {
            ACLMessage msg = (ACLMessage)messages.next();
            if (pattern == null || pattern.match(msg)) {
                messages.remove();
                result = msg;
                break;
            }
            ++cnt;
        }
        return result;
    }

    @Override
    public java.util.List<ACLMessage> receive(MessageTemplate pattern, int max) {
        ArrayList<ACLMessage> mm = null;
        int cnt = 0;
        Iterator messages = this.list.iterator();
        while (messages.hasNext()) {
            ACLMessage msg = (ACLMessage)messages.next();
            if (pattern != null && !pattern.match(msg)) continue;
            messages.remove();
            if (mm == null) {
                mm = new ArrayList<ACLMessage>(max);
            }
            mm.add(msg);
            if (++cnt != max) continue;
            break;
        }
        return mm;
    }

    private Iterator iterator() {
        return this.list.iterator();
    }

    private Long getPersistentID() {
        return this.persistentID;
    }

    private void setPersistentID(Long l) {
        this.persistentID = l;
    }

    @Override
    public void copyTo(List messages) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            messages.add(i.next());
        }
    }

    public String dump(int limit) {
        StringBuilder sb = new StringBuilder();
        Object[] messages = this.list.toArray();
        if (messages.length > 0) {
            int max = limit > 0 ? limit : messages.length;
            for (int j = 0; j < max; ++j) {
                sb.append("Message # ");
                sb.append(j);
                sb.append('\n');
                sb.append(messages[j]);
                sb.append('\n');
            }
        } else {
            sb.append("Queue is empty\n");
        }
        return sb.toString();
    }

    void cleanOldMessages(long maxTime, MessageTemplate pattern) {
        long now = System.currentTimeMillis();
        int cnt = 0;
        Iterator messages = this.iterator();
        while (messages.hasNext()) {
            ACLMessage msg = (ACLMessage)messages.next();
            long postTime = msg.getPostTimeStamp();
            if (postTime > 0L && now - postTime > maxTime && (pattern == null || pattern.match(msg))) {
                messages.remove();
            }
            ++cnt;
        }
    }
}

