/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.CaseInsensitiveString;
import jade.core.CommandProcessor;
import jade.core.IMTPManager;
import jade.core.MainContainerImpl;
import jade.core.ProfileException;
import jade.core.ResourceManager;
import jade.core.ServiceFinder;
import jade.core.ServiceManager;
import jade.mtp.TransportAddress;
import jade.util.leap.List;
import jade.util.leap.Properties;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public abstract class Profile {
    public static final String MAIN = "main";
    public static final String MAIN_PROTO = "proto";
    public static final String MAIN_HOST = "host";
    public static final String MAIN_PORT = "port";
    public static final String DETECT_MAIN = "detect-main";
    public static final String PRIVILEDGE_LOGICAL_NAME = "priviledge-logical-name";
    public static final String LOCAL_HOST = "local-host";
    public static final String LOCAL_PORT = "local-port";
    public static final String LOCAL_PORT_RANGE = "local-port-range";
    public static final String EXPORT_HOST = "export-host";
    public static final String EXPORT_PORT = "export-port";
    public static final String GUI = "gui";
    public static final String LOCAL_SERVICE_MANAGER = "backupmain";
    public static final String DUMP_OPTIONS = "dump-options";
    public static final String NO_DISPLAY = "no-display";
    public static final String OWNER = "owner";
    public static final String DEFAULT_SERVICES = "jade.core.mobility.AgentMobilityService;jade.core.event.NotificationService";
    public static final String DEFAULT_SERVICES_NOMOBILITY = "jade.core.event.NotificationService";
    public static final String PLATFORM_ID = "platform-id";
    public static final String USERAUTH_KEY = "userauth-key";
    public static final String AGENTS = "agents";
    public static final String SERVICES = "services";
    public static final String REMOTE_SERVICE_MANAGER_ADDRESSES = "smaddrs";
    public static final String MTPS = "mtps";
    public static final String NO_MTP = "nomtp";
    public static final String IMTP = "imtp";
    public static final String CONTAINER_NAME = "container-name";
    public static final String AGENT_TAG = "agent-tag";
    public static final String ACLCODECS = "aclcodecs";
    public static final String ACCEPT_FOREIGN_AGENTS = "accept-foreign-agents";
    public static final String STYLE_3_X = "style3-x";
    public static final String FILE_DIR = "file-dir";
    public static final String IP_VERSION = "ip-version";
    public static final int IPV4 = 4;
    public static final int IPV6 = 6;
    public static final int DEFAULT_PORT = 1099;
    public static final String LOCALHOST_CONSTANT = "localhost";
    public static final String LOOPBACK_ADDRESS_CONSTANT = "127.0.0.1";
    public static final String LEAP_IMTP = "LEAP";
    public static final String RMI_IMTP = "RMI";
    public static final String JVM = "jvm";
    public static final String J2SE = "j2se";
    public static final String PJAVA = "pjava";
    public static final String MIDP = "midp";
    public static final String ANDROID = "android";

    protected abstract ServiceManager getServiceManager() throws ProfileException;

    protected abstract ServiceFinder getServiceFinder() throws ProfileException;

    protected abstract CommandProcessor getCommandProcessor() throws ProfileException;

    protected abstract MainContainerImpl getMain() throws ProfileException;

    protected abstract IMTPManager getIMTPManager() throws ProfileException;

    public abstract ResourceManager getResourceManager() throws ProfileException;

    public abstract Properties getBootProperties();

    public abstract String getParameter(String var1, String var2);

    public abstract boolean getBooleanProperty(String var1, boolean var2);

    public abstract List getSpecifiers(String var1) throws ProfileException;

    public abstract void setParameter(String var1, String var2);

    public abstract void setSpecifiers(String var1, List var2);

    public boolean isMain() {
        return this.getBooleanProperty(MAIN, false);
    }

    public boolean isMasterMain() {
        return this.isMain() && !this.getBooleanProperty(LOCAL_SERVICE_MANAGER, false);
    }

    public boolean isBackupMain() {
        return this.isMain() && this.getBooleanProperty(LOCAL_SERVICE_MANAGER, false);
    }

    public static String getDefaultNetworkName() {
        return Profile.getDefaultNetworkName(false);
    }

    public static String getDefaultNetworkName(boolean priviledgeLogicalName) {
        String host = LOCALHOST_CONSTANT;
        try {
            if (priviledgeLogicalName) {
                try {
                    host = InetAddress.getLocalHost().getCanonicalHostName();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (host.equals(LOCALHOST_CONSTANT) || host.equals(LOOPBACK_ADDRESS_CONSTANT)) {
                Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                while (en.hasMoreElements()) {
                    NetworkInterface intf = en.nextElement();
                    Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                    block9: while (enumIpAddr.hasMoreElements()) {
                        InetAddress inetAddress = enumIpAddr.nextElement();
                        if (inetAddress.isLoopbackAddress()) continue;
                        int useIPVersion = Integer.parseInt(System.getProperty(IP_VERSION, String.valueOf(4)));
                        if (inetAddress.isLoopbackAddress()) continue;
                        switch (useIPVersion) {
                            case 4: {
                                if (!(inetAddress instanceof Inet4Address)) continue block9;
                                return inetAddress.getHostAddress().toString();
                            }
                            case 6: {
                                if (!(inetAddress instanceof Inet6Address)) continue block9;
                                return inetAddress.getHostAddress().toString();
                            }
                        }
                        return inetAddress.getHostAddress().toString();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return host;
    }

    public static boolean isLocalHost(String host) {
        if (LOCALHOST_CONSTANT.equalsIgnoreCase(host) || LOOPBACK_ADDRESS_CONSTANT.equals(host)) {
            return true;
        }
        try {
            InetAddress localHostAddr = InetAddress.getByName(host);
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface nextIface = interfaces.nextElement();
                Enumeration<InetAddress> addresses = nextIface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ip = addresses.nextElement();
                    if (!ip.equals(localHostAddr)) continue;
                    return true;
                }
            }
        }
        catch (SocketException e1) {
            e1.printStackTrace();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    public static boolean compareHostNames(String host1, String host2) {
        if (host1 == null || host2 == null) {
            return false;
        }
        if (host1.equalsIgnoreCase(host2)) {
            return true;
        }
        try {
            if (host1.equalsIgnoreCase(LOCALHOST_CONSTANT) || host1.equals(LOOPBACK_ADDRESS_CONSTANT)) {
                return Profile.isLocalHost(host2);
            }
            if (host2.equalsIgnoreCase(LOCALHOST_CONSTANT) || host2.equals(LOOPBACK_ADDRESS_CONSTANT)) {
                return Profile.isLocalHost(host1);
            }
            InetAddress[] host1Addrs = InetAddress.getAllByName(host1);
            InetAddress[] host2Addrs = InetAddress.getAllByName(host2);
            boolean isEqual = false;
            for (int i = 0; !isEqual && i < host1Addrs.length; ++i) {
                for (int j = 0; !isEqual && j < host2Addrs.length; ++j) {
                    isEqual = host1Addrs[i].equals(host2Addrs[j]);
                }
            }
            return isEqual;
        }
        catch (UnknownHostException uhe) {
            return false;
        }
    }

    public static boolean compareTransportAddresses(String addr1, String addr2, IMTPManager imtpManager) {
        try {
            TransportAddress ta1 = imtpManager.stringToAddr(addr1);
            TransportAddress ta2 = imtpManager.stringToAddr(addr2);
            return Profile.compareTransportAddresses(ta1, ta2);
        }
        catch (Exception e) {
            return CaseInsensitiveString.equalsIgnoreCase(addr1, addr2);
        }
    }

    public static boolean compareTransportAddresses(TransportAddress ta1, TransportAddress ta2) {
        String proto1 = ta1.getProto();
        String proto2 = ta2.getProto();
        if (proto1 == null && proto2 == null || CaseInsensitiveString.equalsIgnoreCase(proto1, proto2)) {
            String port1 = ta1.getPort();
            String port2 = ta2.getPort();
            if ((port1 == null && port2 == null || CaseInsensitiveString.equalsIgnoreCase(port1, port2)) && Profile.compareHostNames(ta1.getHost(), ta2.getHost())) {
                return true;
            }
        }
        return false;
    }
}

