/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.AgentContainerImpl;
import jade.core.Profile;
import jade.core.TimerDispatcher;
import jade.core.VersionManager;
import jade.util.Logger;
import jade.util.leap.LinkedList;
import jade.wrapper.AgentContainer;

public class Runtime {
    private static final int MULTIPLE_MODE = 0;
    private static final int SINGLE_MODE = 1;
    private static final int UNKNOWN_MODE = 2;
    private static Runtime theInstance = new Runtime();
    private ThreadGroup criticalThreads;
    private String version = "UNKNOWN";
    private String revision = "UNKNOWN";
    private String date = "UNKNOWN";
    private int activeContainers = 0;
    private LinkedList terminators = new LinkedList();
    private AgentContainerImpl theContainer = null;
    private int mode = 2;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    private Runtime() {
        VersionManager vm = new VersionManager();
        this.version = vm.getVersion();
        this.revision = vm.getRevision();
        this.date = vm.getDate();
    }

    public static Runtime instance() {
        return theInstance;
    }

    public AgentContainer createAgentContainer(Profile p) {
        if (this.mode == 2 || this.mode == 0) {
            this.mode = 0;
            p.setParameter("main", "false");
            AgentContainerImpl impl = new AgentContainerImpl(p);
            this.beginContainer();
            if (impl.joinPlatform()) {
                return impl.getContainerController();
            }
            return null;
        }
        throw new IllegalStateException("Single-container modality already activated");
    }

    public AgentContainer createMainContainer(Profile p) {
        if (this.mode == 2 || this.mode == 0) {
            this.mode = 0;
            p.setParameter("main", "true");
            AgentContainerImpl impl = new AgentContainerImpl(p);
            this.beginContainer();
            if (impl.joinPlatform()) {
                return impl.getContainerController();
            }
            return null;
        }
        throw new IllegalStateException("Single-container modality already activated");
    }

    public void setCloseVM(boolean flag) {
        if (flag) {
            this.terminators.addLast(new Runnable(){

                @Override
                public void run() {
                    Thread.yield();
                    Runtime.this.myLogger.log(Logger.INFO, "JADE is closing down now.");
                    System.exit(0);
                }
            });
        }
    }

    public void startUp(Profile p) {
        if (this.mode == 0) {
            throw new IllegalStateException("Multiple-container modality already activated");
        }
        if (this.mode == 2) {
            this.mode = 1;
            this.theContainer = new AgentContainerImpl(p);
            this.beginContainer();
            this.theContainer.joinPlatform();
        }
    }

    public void shutDown() {
        if (this.theContainer != null) {
            this.theContainer.shutDown();
        }
    }

    public void invokeOnTermination(Runnable r) {
        this.terminators.addFirst(r);
    }

    public void resetTerminators() {
        this.terminators.clear();
    }

    void beginContainer() {
        this.myLogger.log(Logger.INFO, "----------------------------------\n" + Runtime.getCopyrightNotice() + "----------------------------------------");
        if (this.activeContainers == 0) {
            TimerDispatcher theDispatcher = TimerDispatcher.getTimerDispatcher();
            this.criticalThreads = new ThreadGroup("JADE time-critical threads");
            this.criticalThreads.setMaxPriority(10);
            Thread t = new Thread(this.criticalThreads, theDispatcher);
            t.setPriority(this.criticalThreads.getMaxPriority());
            t.setName("JADE Timer dispatcher");
            theDispatcher.setThread(t);
            theDispatcher.start();
        }
        ++this.activeContainers;
    }

    void endContainer() {
        --this.activeContainers;
        if (this.activeContainers == 0) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < Runtime.this.terminators.size(); ++i) {
                        Runnable r = (Runnable)Runtime.this.terminators.get(i);
                        r.run();
                    }
                    Runtime.this.terminators.clear();
                }
            });
            t.setDaemon(false);
            TimerDispatcher.getTimerDispatcher().stop();
            this.mode = 2;
            this.theContainer = null;
            try {
                this.criticalThreads.destroy();
            }
            catch (IllegalThreadStateException itse) {
                this.myLogger.log(Logger.WARNING, "Time-critical threads still active: ");
                this.criticalThreads.list();
            }
            finally {
                this.criticalThreads = null;
            }
            t.start();
        }
    }

    public TimerDispatcher getTimerDispatcher() {
        return TimerDispatcher.getTimerDispatcher();
    }

    public static String getCopyrightNotice() {
        return "    This is " + Runtime.getVersionInfo() + "\n    downloaded in Open Source, under LGPL restrictions,\n    at http://jade.tilab.com/\n";
    }

    public static String getVersionInfo() {
        return "JADE " + Runtime.getVersion() + " - revision " + Runtime.getRevision() + " of " + Runtime.getDate();
    }

    public static String getVersion() {
        return Runtime.theInstance.version;
    }

    public static String getRevision() {
        return Runtime.theInstance.revision;
    }

    public static String getDate() {
        return Runtime.theInstance.date;
    }
}

