/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.Node;
import jade.core.NodeDescriptor;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.VerticalCommand;

public class SliceProxy
implements Service.Slice {
    private Node myNode;
    private transient NodeDescriptor localNodeDescriptor;
    private transient Service myService;

    public SliceProxy() {
        this(null, null);
    }

    public SliceProxy(Service svc, Node n) {
        this.myService = svc;
        this.myNode = n;
    }

    @Override
    public Service getService() {
        return this.myService;
    }

    @Override
    public Node getNode() throws ServiceException {
        return this.myNode;
    }

    public void setNode(Node n) {
        this.myNode = n;
    }

    @Override
    public VerticalCommand serve(HorizontalCommand cmd) {
        try {
            cmd.setReturnValue(this.myNode.accept(cmd));
        }
        catch (IMTPException imtpe) {
            cmd.setReturnValue(new ServiceException("An error occurred while routing the command to the remote implementation", imtpe));
        }
        return null;
    }

    void setLocalNodeDescriptor(NodeDescriptor dsc) {
        this.localNodeDescriptor = dsc;
    }
}

