/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.Agent;
import jade.core.ExtendedMessageQueue;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.leap.List;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class TemplateBasedMessageQueue
extends ExtendedMessageQueue {
    public TemplateBasedMessageQueue(int maxSize, int warningLimit, MessageTemplate warningDiscardTemplate, Agent a) {
        super(maxSize, warningLimit, warningDiscardTemplate, a);
        this.list = new PerTemplateList();
    }

    public TemplateBasedMessageQueue() {
        this(0, 0, null, null);
    }

    public synchronized void registerTemplate(MessageTemplate tpl) {
        LinkedList<ACLMessage> l = new LinkedList<ACLMessage>();
        java.util.List<ACLMessage> mm = super.receive(tpl, -1);
        if (mm != null) {
            l.addAll(mm);
        }
        ((PerTemplateList)this.list).tplListMap.put(tpl, l);
    }

    @Override
    public ACLMessage receive(MessageTemplate pattern) {
        LinkedList tmp = null;
        LinkedList<ACLMessage> l = ((PerTemplateList)this.list).tplListMap.get(pattern);
        if (l != null) {
            tmp = this.list;
            this.list = l;
        }
        ACLMessage msg = super.receive(pattern);
        if (tmp != null) {
            this.list = tmp;
        }
        if (msg != null) {
            --((PerTemplateList)this.list).currentSize;
        }
        return msg;
    }

    @Override
    public java.util.List<ACLMessage> receive(MessageTemplate pattern, int max) {
        LinkedList tmp = null;
        LinkedList<ACLMessage> l = ((PerTemplateList)this.list).tplListMap.get(pattern);
        if (l != null) {
            tmp = this.list;
            this.list = l;
        }
        java.util.List<ACLMessage> mm = super.receive(pattern, max);
        if (tmp != null) {
            this.list = tmp;
        }
        if (mm != null) {
            ((PerTemplateList)this.list).currentSize -= mm.size();
        }
        return mm;
    }

    @Override
    public void copyTo(List messages) {
        Iterator i = this.list.iterator();
        while (i.hasNext()) {
            messages.add(i.next());
        }
        for (LinkedList<ACLMessage> l : ((PerTemplateList)this.list).tplListMap.values()) {
            Iterator i2 = l.iterator();
            while (i2.hasNext()) {
                messages.add(i2.next());
            }
        }
    }

    @Override
    public String dump(int limit) {
        StringBuilder sb = new StringBuilder("Default queue:\n");
        sb.append(super.dump(limit));
        for (Map.Entry<MessageTemplate, LinkedList<ACLMessage>> e : ((PerTemplateList)this.list).tplListMap.entrySet()) {
            sb.append("--------------------------------------\nQueue for Template " + e.getKey() + ":\n");
            LinkedList tmp = this.list;
            this.list = e.getValue();
            sb.append(super.dump(limit));
            this.list = tmp;
        }
        return sb.toString();
    }

    class PerTemplateList
    extends LinkedList<ACLMessage> {
        int currentSize = 0;
        Map<MessageTemplate, LinkedList<ACLMessage>> tplListMap = new HashMap<MessageTemplate, LinkedList<ACLMessage>>();

        PerTemplateList() {
        }

        @Override
        public int size() {
            return this.currentSize;
        }

        @Override
        public void addFirst(ACLMessage msg) {
            LinkedList<ACLMessage> l = this.getPerTplList(msg);
            if (l != null) {
                l.addFirst(msg);
            } else {
                super.addFirst(msg);
            }
            ++this.currentSize;
        }

        @Override
        public void addLast(ACLMessage msg) {
            LinkedList<ACLMessage> l = this.getPerTplList(msg);
            if (l != null) {
                l.addLast(msg);
            } else {
                super.addLast(msg);
            }
            ++this.currentSize;
        }

        LinkedList<ACLMessage> getPerTplList(ACLMessage msg) {
            for (Map.Entry<MessageTemplate, LinkedList<ACLMessage>> e : this.tplListMap.entrySet()) {
                if (!e.getKey().match(msg)) continue;
                return e.getValue();
            }
            return null;
        }
    }
}

