/*
 * Decompiled with CFR 0.152.
 */
package jade.core.behaviours;

import jade.core.behaviours.Behaviour;
import jade.util.Logger;
import java.io.Serializable;

public class OutcomeManager
implements Serializable {
    private static final long serialVersionUID = -87842234567654L;
    public static final int OK = 1;
    public static final int KO = 0;
    private Behaviour bh;
    private int exitCode = 1;
    private String errorMsg;
    private Logger myLogger = Logger.getJADELogger(this.getClass().getName());

    public OutcomeManager(Behaviour bh) {
        this.bh = bh;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public boolean isSuccessful() {
        return this.exitCode == 1;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void error(String msg, Exception e) {
        this.exitCode = 0;
        if (e != null) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.bh.getAgent().getLocalName() + " - " + msg, e);
            String exMsg = e.getMessage() != null ? e.getMessage() : e.getClass().getName();
            this.errorMsg = msg + " - " + exMsg;
        } else {
            this.myLogger.log(Logger.WARNING, "Agent " + this.bh.getAgent().getLocalName() + " - " + msg);
            this.errorMsg = msg;
        }
    }

    public void propagateError(String msg) {
        this.exitCode = 0;
        this.errorMsg = msg;
    }
}

