/*
 * Decompiled with CFR 0.152.
 */
package jade.core.event;

import jade.core.AID;
import jade.core.ContainerID;
import jade.core.event.JADEEvent;
import jade.wrapper.PlatformController;

public class PlatformEvent
extends JADEEvent
implements jade.wrapper.PlatformEvent {
    public static final int ADDED_CONTAINER = 1;
    public static final int REMOVED_CONTAINER = 2;
    public static final int MOVED_AGENT = 5;
    public static final int SUSPENDED_AGENT = 6;
    public static final int RESUMED_AGENT = 7;
    public static final int CHANGED_AGENT_PRINCIPAL = 8;
    public static final int CHANGED_CONTAINER_PRINCIPAL = 9;
    public static final int FROZEN_AGENT = 10;
    public static final int THAWED_AGENT = 11;
    private ContainerID newContainer = null;
    private String myPlatformName = null;
    private AID agent = null;
    private String oldOwnership = null;
    private String newOwnership = null;
    private boolean containerRemoved = false;

    public PlatformEvent(int id, ContainerID eventSource) {
        super(id, eventSource);
        if (!this.isContainerBD()) {
            throw new InternalError("Bad event kind: it must be a container related kind.");
        }
    }

    public PlatformEvent(int id, AID aid, ContainerID eventSource) {
        super(id, eventSource);
        if (!this.isAgentBD()) {
            throw new InternalError("Bad event kind: it must be an agent related kind.");
        }
        this.agent = aid;
    }

    public PlatformEvent(int id, AID aid, ContainerID eventSource, boolean cr) {
        super(id, eventSource);
        if (!this.isAgentBD()) {
            throw new InternalError("Bad event kind: it must be an agent related kind.");
        }
        this.agent = aid;
        this.containerRemoved = cr;
    }

    public PlatformEvent(AID aid, ContainerID eventSource, ContainerID to) {
        super(5, eventSource);
        this.agent = aid;
        this.newContainer = to;
    }

    public PlatformEvent(int id, AID aid, ContainerID from, ContainerID to) {
        super(id, from);
        this.agent = aid;
        this.newContainer = to;
    }

    public PlatformEvent(int id, AID aid, ContainerID eventSource, String oldOwnership, String newOwnership) {
        super(id, eventSource);
        this.agent = aid;
        this.oldOwnership = oldOwnership;
        this.newOwnership = newOwnership;
    }

    public ContainerID getContainer() {
        return (ContainerID)this.getSource();
    }

    public ContainerID getNewContainer() {
        return this.newContainer;
    }

    public AID getAgent() {
        return this.agent;
    }

    public String getOldOwnership() {
        return this.oldOwnership;
    }

    public String getNewOwnership() {
        return this.newOwnership;
    }

    public boolean getContainerRemoved() {
        return this.containerRemoved;
    }

    public boolean isContainerBD() {
        return this.type == 1 || this.type == 2;
    }

    public boolean isAgentBD() {
        return this.type == 3 || this.type == 4 || this.type == 6 || this.type == 7 || this.type == 10;
    }

    @Override
    public int getEventType() {
        return this.type;
    }

    public void setSource(Object s) {
        this.source = s;
        if (this.source instanceof PlatformController) {
            this.myPlatformName = ((PlatformController)this.source).getName();
        }
    }

    @Override
    public String getPlatformName() {
        return this.myPlatformName;
    }

    @Override
    public String getAgentGUID() {
        if (this.agent != null) {
            return this.agent.getName();
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(128);
        buf.append("PlatformEvent[");
        switch (this.type) {
            case 1: {
                buf.append("add container: ").append(this.getSource());
                break;
            }
            case 2: {
                buf.append("remove container: ").append(this.getSource());
                break;
            }
            case 3: {
                buf.append("born agent: ").append(this.agent).append(" in ").append(this.getSource());
                break;
            }
            case 4: {
                buf.append("dead agent: ").append(this.agent).append(" in ").append(this.getSource());
                break;
            }
            case 6: {
                buf.append("suspended agent: ").append(this.agent).append(" in ").append(this.getSource());
                break;
            }
            case 7: {
                buf.append("resumed agent: ").append(this.agent).append(" in ").append(this.getSource());
                break;
            }
            case 5: {
                buf.append("moved agent: ").append(this.agent).append(" from: ").append(this.getSource()).append(" to: ").append(this.newContainer);
                break;
            }
            case 8: {
                buf.append("changed agent ownership: ").append(this.agent).append(" in: ").append(this.getSource()).append(" from: ").append(this.oldOwnership).append(" to: ").append(this.newOwnership);
                break;
            }
            case 9: {
                buf.append("changed container ownership: ").append(this.getSource()).append(" from: ").append(this.oldOwnership).append(" to: ").append(this.newOwnership);
                break;
            }
            default: {
                buf.append("Error: bad event type ID in PlatformEvent.toString()");
            }
        }
        buf.append("]");
        return buf.toString();
    }
}

