/*
 * Decompiled with CFR 0.152.
 */
package jade.core.faultRecovery;

import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.BaseService;
import jade.core.Filter;
import jade.core.GenericCommand;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.MainContainer;
import jade.core.Node;
import jade.core.NodeDescriptor;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.ServiceHelper;
import jade.core.VerticalCommand;
import jade.core.faultRecovery.FaultRecoveryHelper;
import jade.core.faultRecovery.PersistentStorage;
import jade.core.replication.MainReplicationService;
import jade.util.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;

public class FaultRecoveryService
extends BaseService {
    public static final String NAME = "jade.core.faultRecovery.FaultRecovery";
    public static final String CLEAN_STORAGE = "jade_core_faultRecovery_FaultRecoveryService_cleanstorage";
    public static final String PERSISTENT_STORAGE_CLASS = "jade_core_faultRecovery_FaultRecoveryService_persistentstorage";
    public static final String ORPHAN_NODE_POLICY = "jade_core_faultRecovery_FaultRecoveryService_orphannodepolicy";
    public static final String PERSISTENT_STORAGE_CLASS_DEFAULT = "jade.core.faultRecovery.FSPersistentStorage";
    public static final String ORPHAN_NODE_POLICY_RECOVER = "RECOVER";
    public static final String ORPHAN_NODE_POLICY_KILL = "KILL";
    public static final String ORPHAN_NODE_POLICY_IGNORE = "IGNORE";
    public static final String H_KILLNODE = "1";
    private AgentContainer myContainer;
    private MainContainer myMain;
    private Filter inpFilter;
    private Filter outFilter;
    private PersistentStorage myPS;
    private NodeSerializer nodeSerializer;
    private boolean bootComplete = false;
    private String orphanNodePolicy;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void init(AgentContainer ac, Profile p) throws ProfileException {
        super.init(ac, p);
        this.myContainer = ac;
        this.myMain = this.myContainer.getMain();
        if (this.myMain != null) {
            this.inpFilter = new MainCommandIncomingFilter();
            this.outFilter = new MainCommandOutgoingFilter();
            this.nodeSerializer = new NodeSerializer();
            this.orphanNodePolicy = p.getParameter(ORPHAN_NODE_POLICY, ORPHAN_NODE_POLICY_RECOVER);
            String psClass = p.getParameter(PERSISTENT_STORAGE_CLASS, PERSISTENT_STORAGE_CLASS_DEFAULT);
            try {
                this.myLogger.log(Logger.CONFIG, "Loading PersistentStorage of class " + psClass);
                this.myPS = (PersistentStorage)Class.forName(psClass).newInstance();
                this.myPS.init(p);
                boolean cleanStorage = p.getBooleanProperty(CLEAN_STORAGE, false);
                if (!cleanStorage) return;
                this.myLogger.log(Logger.CONFIG, "Clearing PersistentStorage ...");
                this.myPS.clear(true);
                return;
            }
            catch (Exception e) {
                String msg = "Error initializing PersistentStorage. ";
                this.myLogger.log(Logger.SEVERE, msg, e);
                if (this.myPS == null) throw new ProfileException(msg, e);
                this.myPS.close();
                throw new ProfileException(msg, e);
            }
        } else {
            this.inpFilter = new ContainerCommandIncomingFilter();
        }
    }

    @Override
    public void boot(Profile p) throws ServiceException {
        if (this.myMain != null) {
            try {
                String[] platformInfo = this.myPS.getPlatformInfo();
                String oldPlatformName = platformInfo != null ? platformInfo[0] : null;
                String oldAddress = platformInfo != null ? platformInfo[1] : null;
                String currentPlatformName = this.myContainer.getPlatformID();
                String currentAddress = this.myContainer.getServiceManager().getLocalAddress();
                this.myPS.storePlatformInfo(currentPlatformName, currentAddress);
                if (currentPlatformName.equals(oldPlatformName)) {
                    MainReplicationService replService = (MainReplicationService)this.myContainer.getServiceFinder().findService("jade.core.replication.MainReplication");
                    if (replService == null || replService.getAllSlices().length <= 1) {
                        this.myLogger.log(Logger.INFO, "Initiating fault recovery procedure...");
                        Map allNodes = this.myPS.getAllNodes(false);
                        for (String name : allNodes.keySet()) {
                            this.checkNode(name, (byte[])allNodes.get(name), oldAddress, currentAddress);
                        }
                        allNodes = this.myPS.getAllNodes(true);
                        for (String name : allNodes.keySet()) {
                            this.checkNode(name, (byte[])allNodes.get(name), oldAddress, currentAddress);
                        }
                        this.myLogger.log(Logger.INFO, "Fault recovery procedure completed.");
                    }
                } else {
                    this.myPS.clear(false);
                }
            }
            catch (Exception e) {
                String msg = "Error recovering from previous fault. ";
                this.myLogger.log(Logger.SEVERE, msg, e);
                throw new ServiceException(msg, e);
            }
        }
        this.bootComplete = true;
    }

    @Override
    public void shutdown() {
        if (this.myPS != null) {
            try {
                this.myPS.clear(true);
                this.myPS.close();
            }
            catch (Exception e) {
                this.myLogger.log(Logger.WARNING, "Unexpected error clearing PersistentStorage. ", e);
            }
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Filter getCommandFilter(boolean direction) {
        if (!direction) {
            return this.inpFilter;
        }
        return this.outFilter;
    }

    @Override
    public Service.Slice getLocalSlice() {
        return new Service.Slice(){

            @Override
            public Service getService() {
                return FaultRecoveryService.this;
            }

            @Override
            public Node getNode() throws ServiceException {
                try {
                    return FaultRecoveryService.this.getLocalNode();
                }
                catch (IMTPException imtpe) {
                    throw new ServiceException("Problem in contacting the IMTP Manager", imtpe);
                }
            }

            @Override
            public VerticalCommand serve(HorizontalCommand cmd) {
                try {
                    String cmdName = cmd.getName();
                    if (cmdName.equals(FaultRecoveryService.H_KILLNODE)) {
                        FaultRecoveryService.this.suicide();
                    }
                }
                catch (Throwable t) {
                    cmd.setReturnValue(t);
                }
                return null;
            }
        };
    }

    @Override
    public ServiceHelper getHelper(Agent a) throws ServiceException {
        return new FaultRecoveryHelper(){

            @Override
            public void init(Agent a) {
            }

            @Override
            public void reattach() throws ServiceException {
                try {
                    Node n = FaultRecoveryService.this.myContainer.getNodeDescriptor().getNode();
                    String pmAddress = FaultRecoveryService.this.myContainer.getServiceManager().getLocalAddress();
                    n.platformManagerDead(pmAddress, pmAddress);
                }
                catch (IMTPException imtpe) {
                    throw new ServiceException("Communication error: " + imtpe.getMessage(), imtpe);
                }
            }
        };
    }

    private void checkNode(String name, byte[] nn, String oldAddress, String currentAddress) {
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Recovering node " + name + " ...");
        }
        Node node = null;
        try {
            node = this.nodeSerializer.deserialize(nn);
            node.platformManagerDead(oldAddress, currentAddress);
            this.myLogger.log(Logger.INFO, "Node " + name + " successfully recovered.");
            return;
        }
        catch (IMTPException imtpe) {
            this.myLogger.log(Logger.INFO, "Node " + name + " unreachable. It has likely been killed in the meanwhile");
        }
        catch (Exception e) {
            this.myLogger.log(Logger.WARNING, "Error deserializing node " + name + ". ", e);
        }
        try {
            this.myPS.removeNode(node.getName());
        }
        catch (Exception ex) {
            this.myLogger.log(Logger.WARNING, "Cannot remove node " + node.getName() + " from persistent storage. ", ex);
        }
    }

    private void killNode(String name, byte[] nn) {
        Node node = null;
        try {
            node = this.nodeSerializer.deserialize(nn);
            GenericCommand cmd = new GenericCommand(H_KILLNODE, NAME, null);
            node.accept(cmd);
            this.myLogger.log(Logger.INFO, "Node " + name + " successfully killed.");
        }
        catch (IMTPException imtpe) {
            this.myLogger.log(Logger.INFO, "Node " + name + " unreachable (it has likely been killed in the meanwhile) or does not support fault recovery.");
        }
        catch (Exception e) {
            this.myLogger.log(Logger.WARNING, "Error deserializing node " + name + ". ", e);
        }
        try {
            this.myPS.removeNode(node.getName());
        }
        catch (Exception ex) {
            this.myLogger.log(Logger.WARNING, "Cannot remove node " + node.getName() + " from persistent storage. ", ex);
        }
    }

    private void handleNewNode(NodeDescriptor dsc) throws Exception {
        Node node = dsc.getNode();
        if (!node.hasPlatformManager()) {
            byte[] nn = this.nodeSerializer.serialize(node);
            this.myPS.storeNode(node.getName(), dsc.getParentNode() != null, nn);
            this.myLogger.log(Logger.FINE, "Node " + node.getName() + " added to persistent storage.");
        }
    }

    private void handleDeadNode(NodeDescriptor dsc) throws Exception {
        Node node = dsc.getNode();
        if (!node.hasPlatformManager()) {
            this.myPS.removeNode(node.getName());
            this.myLogger.log(Logger.FINE, "Node " + node.getName() + " removed from persistent storage.");
        }
    }

    private void handleNodeUnreachable(Node node) throws Exception {
        if (!node.hasPlatformManager()) {
            this.myPS.setUnreachable(node.getName());
            this.myLogger.log(Logger.FINE, "Node " + node.getName() + " marked as unreachable.");
        }
    }

    private void handleNodeReachable(Node node) throws Exception {
        if (!node.hasPlatformManager()) {
            this.myPS.resetUnreachable(node.getName());
            this.myLogger.log(Logger.FINE, "Node " + node.getName() + " marked as reachable.");
        }
    }

    private void handleOrphanNode(String nodeName) {
        if (this.bootComplete) {
            this.myLogger.log(Logger.INFO, "Handling orphan node " + nodeName + "...");
            try {
                byte[] nn = this.myPS.getUnreachableNode(nodeName);
                if (nn != null) {
                    if (this.orphanNodePolicy.equals(ORPHAN_NODE_POLICY_RECOVER)) {
                        this.myLogger.log(Logger.INFO, "Try to recover orphan node " + nodeName);
                        String address = this.myContainer.getServiceManager().getLocalAddress();
                        this.checkNode(nodeName, nn, address, address);
                    } else if (this.orphanNodePolicy.equals(ORPHAN_NODE_POLICY_KILL)) {
                        this.myLogger.log(Logger.INFO, "Try to kill orphan node " + nodeName);
                        this.killNode(nodeName, nn);
                    } else if (this.orphanNodePolicy.equals(ORPHAN_NODE_POLICY_IGNORE)) {
                        // empty if block
                    }
                } else {
                    this.myLogger.log(Logger.INFO, "Orphan node " + nodeName + " not found in persistent storage");
                }
            }
            catch (Exception e) {
                this.myLogger.log(Logger.WARNING, "Error searching for unreachable node " + nodeName + " in the persistent storage", e);
            }
        }
    }

    private void handleReattached() {
        this.myLogger.log(Logger.INFO, "Re-adding all local agents to recovered main container...");
        AID[] ids = this.myContainer.agentNames();
        for (int i = 0; i < ids.length; ++i) {
            AID id = ids[i];
            Agent agent = this.myContainer.acquireLocalAgent(id);
            if (agent != null) {
                if (this.myLogger.isLoggable(Logger.CONFIG)) {
                    this.myLogger.log(Logger.CONFIG, "Re-adding agent " + id.getName());
                }
                try {
                    this.myContainer.initAgent(agent.getAID(), agent, null, null);
                }
                catch (Exception e) {
                    this.myLogger.log(Logger.SEVERE, "Error reattaching agent " + id.getName() + ". ", e);
                }
            }
            this.myContainer.releaseLocalAgent(id);
        }
    }

    private void suicide() {
        this.myLogger.log(Logger.WARNING, "Activating suicide procedure.....");
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                FaultRecoveryService.this.myLogger.log(Logger.WARNING, "Suiciding NOW!!!!!!");
                System.exit(0);
            }
        };
        t.start();
    }

    public class NodeSerializer {
        public byte[] serialize(Node n) throws Exception {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream encoder = new ObjectOutputStream(out);
            encoder.writeObject(n);
            return out.toByteArray();
        }

        public Node deserialize(byte[] bb) throws Exception {
            ByteArrayInputStream inp = new ByteArrayInputStream(bb);
            ObjectInputStream decoder = new ObjectInputStream(inp);
            return (Node)decoder.readObject();
        }
    }

    private class ContainerCommandIncomingFilter
    extends Filter {
        private ContainerCommandIncomingFilter() {
        }

        @Override
        public boolean accept(VerticalCommand cmd) {
            String name = cmd.getName();
            try {
                if (name.equals("Reattached")) {
                    FaultRecoveryService.this.handleReattached();
                }
            }
            catch (Exception e) {
                FaultRecoveryService.this.myLogger.log(Logger.WARNING, "Error processing command " + name + ". ", e);
            }
            return true;
        }
    }

    private class MainCommandOutgoingFilter
    extends Filter {
        private MainCommandOutgoingFilter() {
        }

        @Override
        public boolean accept(VerticalCommand cmd) {
            String name = cmd.getName();
            try {
                if (name.equals("Node-Unreachable")) {
                    FaultRecoveryService.this.handleNodeUnreachable((Node)cmd.getParams()[0]);
                } else if (name.equals("Node-Unreachable")) {
                    FaultRecoveryService.this.handleNodeReachable((Node)cmd.getParams()[0]);
                } else if (name.equals("Orphan-Node")) {
                    FaultRecoveryService.this.handleOrphanNode((String)cmd.getParams()[0]);
                }
            }
            catch (Exception e) {
                FaultRecoveryService.this.myLogger.log(Logger.WARNING, "Error processing command " + name + ". ", e);
            }
            return true;
        }
    }

    private class MainCommandIncomingFilter
    extends Filter {
        private MainCommandIncomingFilter() {
        }

        @Override
        public boolean accept(VerticalCommand cmd) {
            String name = cmd.getName();
            try {
                if (name.equals("New-Node")) {
                    FaultRecoveryService.this.handleNewNode((NodeDescriptor)cmd.getParams()[0]);
                }
                if (name.equals("Adopted-Node")) {
                    FaultRecoveryService.this.handleNewNode((NodeDescriptor)cmd.getParams()[0]);
                } else if (name.equals("Dead-Node")) {
                    FaultRecoveryService.this.handleDeadNode((NodeDescriptor)cmd.getParams()[0]);
                }
            }
            catch (Exception e) {
                FaultRecoveryService.this.myLogger.log(Logger.WARNING, "Error processing command " + name + ". ", e);
            }
            return true;
        }
    }
}

